---
name: product-market-fit-radar
version: 1.0.0
---

# Initialization

Product-Market Fit Radar is a diagnostic and analytical framework that helps founders and product managers objectively measure their journey toward product-market fit. It combines the Sean Ellis Test (40% Rule), retention cohort analysis, and multi-dimensional radar visualization to identify exactly which part of the growth engine needs work.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive PMF diagnostic frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r product-market-fit-radar/ ~/.claude/skills/product-market-fit-radar/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_model}}` | `B2B SaaS` | Your business model type (B2B SaaS, B2C Subscription, Marketplace, Consumer App) |
| `{{growth_stage}}` | `Seed` | Current funding stage (Pre-seed, Seed, Series A, Series B+) |
| `{{core_metric}}` | `Retention` | Primary metric focus (Retention, Engagement, Revenue, Satisfaction) |
| `{{target_audience}}` | `General` | Target customer segment (Enterprise, SMB, Prosumer, Consumer, Gen Z) |
| `{{data_format}}` | `Summary` | How data is provided (Raw CSV, Summary Stats, Qualitative Description) |

## Core Capabilities

1. **PMF Score Calculation**: Analyzes Sean Ellis survey results and calculates the "40% rule" score
2. **Retention Curve Analysis**: Interprets cohort retention data to identify flattening vs declining patterns
3. **Radar Visualization**: Maps product health across 5 axes (Satisfaction, Retention, Engagement, Growth, Economics)
4. **Strategic Recommendations**: Provides specific "Next Best Actions" based on diagnostic results
5. **Persona Segmentation**: Identifies High Expectation Customers (HXC) to refine ICP

## Example Usage

```
I'm building a B2B SaaS tool for legal document automation at the Seed stage.
I just ran the Sean Ellis survey with 150 responses:
- 35 said "Very Disappointed"
- 60 said "Somewhat Disappointed"
- 55 said "Not Disappointed"

Calculate my PMF score, analyze what questions I should ask the "Somewhat Disappointed"
group to convert them, and generate a radar assessment of my current position.
```

## Key Frameworks Included

- **Sean Ellis Test (40% Rule)** - Survey methodology and interpretation
- **Retention Curve Analysis** - Cohort analysis and benchmark comparison
- **PMF Radar Assessment** - 5-axis multi-dimensional health visualization
- **High Expectation Customer (HXC) Identification** - ICP refinement process
- **Leaky Bucket Diagnosis** - Identifying acquisition vs retention problems
- **Stage-Appropriate Benchmarks** - B2B SaaS, B2C, Marketplace, Consumer App standards

## Research Sources

This skill synthesizes insights from:
- Superhuman PMF Engine (Rahul Vohra / First Round)
- Andrew Chen's Investor Metrics
- Lenny's Newsletter PMF Benchmarks
- Y Combinator Startup School
- Reforge Growth Series
- a16z Growth Metrics Dictionary

---
Downloaded from [Find Skill.ai](https://findskill.ai)
