---
name: saas-churn-analyzer
version: 1.0.0
---

# SaaS Churn Analyzer - Initialization

Expert AI skill for predicting customer churn, building health scoring systems, segmenting at-risk accounts, and designing win-back campaigns for SaaS businesses.

## What This Skill Does

- **Churn Prediction**: Build ML models (XGBoost, Random Forest) achieving 90-96% accuracy to identify at-risk customers weeks before cancellation
- **Health Scoring**: Create weighted scoring systems aggregating usage, support, and satisfaction metrics into actionable red/yellow/green indicators
- **Customer Segmentation**: Apply RFM analysis to prioritize high-value customers and tailor retention strategies
- **Win-Back Campaigns**: Design personalized reactivation campaigns with 10-40% success rates
- **Root Cause Analysis**: Identify why customers churn through behavioral and survey data analysis

## Structure

```
saas-churn-analyzer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r saas-churn-analyzer/ ~/.claude/skills/saas-churn-analyzer/
```

Then reference in conversations with: "Use the saas-churn-analyzer skill"

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "# SaaS Churn Analyzer")
3. Paste into Custom GPT instructions or conversation

### Gemini

1. Open `SKILL.md`
2. Copy the content after frontmatter
3. Paste at the start of your conversation as context

### Copilot

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Use as system prompt or paste into chat

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{churn_prediction_threshold}}` | `0.65` | Probability threshold for flagging at-risk customers (0.5-0.8 range) |
| `{{days_inactive_threshold}}` | `30` | Days without activity to trigger at-risk flag |
| `{{health_score_model}}` | `weighted_aggregate` | Scoring methodology: weighted_aggregate, rules_based, or ml_model |
| `{{retention_campaign_frequency}}` | `weekly` | How often to identify at-risk customers (daily, weekly, monthly) |
| `{{win_back_offer_discount}}` | `0.20` | Discount percentage for win-back campaigns (0.10-0.30) |
| `{{feature_adoption_target}}` | `3` | Minimum core features for engaged customer status |

## Quick Start Examples

### Predict At-Risk Customers
```
I have 12 months of customer data including login frequency, feature usage,
support tickets, NPS scores, and contract details. Monthly churn is 4%.
Build a churn prediction model that identifies accounts with >70% probability
of cancelling in the next 90 days.
```

### Design Health Score System
```
We have 5,000 SaaS customers. Design a customer health scoring system
that helps our 10-person CS team identify which accounts need attention.
Include product usage, support metrics, and NPS in the scoring model.
```

### Create Win-Back Campaign
```
We lost 200 customers in Q4. Exit surveys show: 60 left due to pricing,
80 left due to missing features (now available), 60 left due to poor support.
Develop win-back campaign strategies for each segment.
```

## Key Capabilities

1. **ML Model Selection**: Recommends XGBoost, Random Forest, or Logistic Regression based on data characteristics
2. **Feature Engineering**: Creates predictive features from usage, support, and financial data
3. **Class Imbalance Handling**: Applies ADASYN/SMOTE for typical 2-5% churn datasets
4. **Threshold Optimization**: Balances precision/recall based on CS team capacity
5. **SHAP Interpretation**: Explains WHY customers are flagged as at-risk
6. **RFM Segmentation**: Creates customer segments for targeted retention
7. **Campaign Personalization**: Designs segment-specific win-back messaging

## Requirements

- Customer data (usage logs, support tickets, payment history)
- Minimum 3-6 months historical data with churn labels
- Knowledge of current churn rate (monthly/annual)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
