---
name: spreadsheet-troubleshooter
version: 1.0.0
description: Debug Excel and Google Sheets errors, fix broken formulas, diagnose slow spreadsheets
author: FindSkill.ai
license: MIT
---

# Initialization

A specialized debugging companion for Excel and Google Sheets. While other skills help you write formulas, this skill helps you fix problems: decode cryptic error messages, diagnose why formulas aren't working, and optimize slow spreadsheets.

## What Makes This Different

| Formula Writing Skills | Spreadsheet Troubleshooter |
|------------------------|---------------------------|
| Creates new formulas | Fixes broken formulas |
| "How do I write..." | "Why doesn't this work..." |
| Syntax guidance | Error diagnosis |
| Formula templates | Root cause analysis |

## Structure

This is a prompt-only skill:

```
spreadsheet-troubleshooter/
├── SKILL.md    # Main skill prompt
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r spreadsheet-troubleshooter/ ~/.claude/skills/spreadsheet-troubleshooter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

Works with: Excel 365, Excel 2021/2019/2016, Google Sheets, LibreOffice Calc

## Variables

Customize these when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `spreadsheet_app` | Excel | Which app (Excel, Google Sheets) |
| `excel_version` | 365 | Excel version if applicable |

## Key Features

### 1. Error Message Decoder
Comprehensive coverage of all Excel/Sheets error types:
- **#VALUE!** - Data type mismatches
- **#REF!** - Invalid cell references
- **#NAME?** - Unrecognized names/functions
- **#N/A** - Lookup failures
- **#DIV/0!** - Division by zero
- **#NULL!** - Incorrect range operators
- **#NUM!** - Invalid numeric values

### 2. Slow Spreadsheet Diagnostics
Identifies and fixes performance problems:
- Volatile functions (NOW, TODAY, OFFSET, INDIRECT)
- Whole-column references
- Array formula optimization
- Conditional formatting cleanup
- File size reduction

### 3. Data Issues Detective
Finds hidden problems in your data:
- Hidden characters (spaces, line breaks)
- Number vs. text formatting
- Date format issues
- Circular references

### 4. Root Cause Analysis
Doesn't just fix - explains WHY:
- What caused the error
- How to prevent it
- Best practices for the future

## Common Use Cases

### Error Debugging
"My formula =VLOOKUP(A2,Sheet2!A:D,5,FALSE) returns #REF!"
→ Identifies col_index (5) exceeds column count (4)

### Performance Issues
"My spreadsheet takes 30 seconds to recalculate"
→ Finds volatile functions, whole-column references

### Unexpected Results
"This formula should return 100 but shows 0"
→ Discovers text-formatted numbers

### Lookup Failures
"VLOOKUP can't find a value I can see in the data"
→ Identifies trailing spaces or text/number mismatch

## Example Interaction

**User**: My Excel formula =VLOOKUP(A2,Sheet2!A:D,5,FALSE) is returning #REF! and I don't understand why.

**Skill Response**:

```
## The Problem
Your VLOOKUP is returning a #REF! error.

## Root Cause
The col_index (5) is larger than your lookup range (A:D = 4 columns).
VLOOKUP's col_index tells Excel which column to return, counting from the left of your lookup range.
- Column 1 = A
- Column 2 = B
- Column 3 = C
- Column 4 = D
- Column 5 = ??? (doesn't exist!)

## The Fix
=VLOOKUP(A2,Sheet2!A:E,5,FALSE)
OR
=VLOOKUP(A2,Sheet2!A:D,4,FALSE)

## Explanation
Either expand your range to include column E, or change col_index to 4 if you want data from column D.

## Prevention
Always count columns: if your range is A:D, your col_index must be 1-4.
Consider using INDEX/MATCH for more flexibility.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
