---
name: technical-debt-analyzer
version: 1.0.0
---

# Technical Debt Analyzer - Initialization

A decision-support system for engineering leaders to quantify technical debt in business terms, calculate ROI for refactoring decisions, forecast sustainability breaking points, and build stakeholder consensus on debt reduction investments.

## Package Contents

```
technical-debt-analyzer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file - setup instructions
```

## Quick Start

### Claude Code / Claude Desktop
```bash
# Copy skill to Claude Code skills directory
cp -r technical-debt-analyzer/ ~/.claude/skills/technical-debt-analyzer/

# Or add to project-specific skills
cp -r technical-debt-analyzer/ .claude/skills/technical-debt-analyzer/
```

### ChatGPT / GPT-4
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new Custom GPT or chat session as system instructions

### Gemini / Other AI Assistants
1. Open `SKILL.md`
2. Copy the skill content
3. Paste as context at the start of your conversation

## Variables

Customize these values based on your context:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{team_size}}` | `8` | Number of engineers on the team |
| `{{codebase_size}}` | `50000` | Lines of code in the codebase |
| `{{codebase_age_years}}` | `3` | Age of the codebase in years |
| `{{tech_stack}}` | `Python/React` | Primary technologies used |
| `{{debt_allocation_percentage}}` | `0.20` | Target % of capacity for debt reduction |
| `{{target_interest_rate}}` | `0.15` | Acceptable debt interest rate threshold |
| `{{break_even_roi_months}}` | `12` | Max payback period to approve refactoring |
| `{{forecast_horizon_months}}` | `12` | How far ahead to forecast debt growth |

## Core Capabilities

### 1. Debt Assessment & Inventory
Create comprehensive catalogs of technical debt across categories:
- Code quality (smells, complexity, duplications)
- Architecture (monoliths, coupling, patterns)
- Security (vulnerabilities, outdated auth)
- Performance (N+1 queries, memory leaks)
- Dependencies (outdated libraries, deprecated APIs)
- Testing (coverage gaps, flaky tests)
- DevEx (slow builds, painful deploys)

### 2. ROI-Based Prioritization
Calculate business value of refactoring decisions:
```
Break-Even = Remediation Cost / Monthly Interest Cost
```
Compare debt reduction ROI against feature development ROI.

### 3. Breaking Point Forecasting
Predict when system becomes unmaintainable:
```
Future Debt = Current Debt × (1 + Interest Rate)^Quarters
BP Reached When: Maintenance Time > 40% of Dev Hours
```

### 4. Stakeholder Communication
Translate technical metrics to business language:
- Convert code smells to $ cost
- Show velocity decline projections
- Build business cases for non-technical executives

### 5. Capacity Allocation
Recommend engineering time splits:
- Industry baseline: 60% features, 20% debt, 20% reactive
- Adjust based on debt velocity and breaking point proximity

## Key Concepts

| Term | Definition |
|------|------------|
| **Technical Debt Principal** | Hours/cost to remediate all shortcuts |
| **Interest Rate** | % of dev time spent on debt maintenance |
| **Technical Debt Ratio** | Proportion of time on debt vs. features |
| **Breaking Point** | When interest exceeds creation capacity |
| **Debt Velocity** | Rate of new debt vs. remediation |
| **Quadrant Method** | 2×2 matrix: Impact × Effort prioritization |

## Example Usage

```
"Our 50K-line Python/React codebase is 3 years old and we have an 8-person
engineering team. We feel constantly behind on features. Help me assess our
technical debt situation and build a business case for allocating 20% of
sprint capacity to debt reduction. I need to convince our VP of Product."
```

## Integration with Tools

Works well alongside:
- **SonarQube** - Automated debt discovery
- **CodeClimate** - Code quality metrics
- **Jira/Linear** - Debt backlog tracking
- **DORA metrics** - Velocity measurement

## Related Skills

- Cost-Benefit Analysis (ROI calculations)
- KPI & Metrics Designer (progress tracking)
- Code Reviewer Pro (debt identification)
- Senior Architect (architectural decisions)
- Executive Dashboards (stakeholder reporting)

## Research Foundation

This skill is built on validated frameworks:
- **Tracy Framework** - Business-driven prioritization (IEEE)
- **SQALE Method** - Debt quantification
- **TD Breaking Point** - Sustainability forecasting
- **Gartner Method** - Risk-based prioritization

## Success Metrics

After using this skill, track:
- Technical Debt Ratio: Target <5%
- Interest Rate: Target <15%
- Debt Velocity: Should turn negative
- Development Velocity: Should improve 10-30%
- Deployment Frequency: Should increase

---
Downloaded from [Find Skill.ai](https://findskill.ai)
