---
name: vendor-selection-evaluator
version: 1.0.0
---

# Vendor Selection Evaluator - Initialization

Transform subjective vendor selection into objective, defensible procurement decisions using weighted scorecards and multi-criteria decision-making (MCDM) frameworks.

## What This Skill Does

- Creates weighted evaluation scorecards for vendor comparison
- Calculates Total Cost of Ownership (TCO) across vendors
- Assesses vendor risk profiles (financial, operational, compliance)
- Guides multi-criteria decision-making using WSM, AHP, or TOPSIS
- Generates reference check frameworks and performance monitoring KPIs
- Produces defensible procurement documentation

## Package Structure

```
vendor-selection-evaluator/
├── SKILL.md   # Main skill prompt (copy to AI assistant)
├── INIT.md    # This initialization file
└── index.md   # Hugo page file (for website display)
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md contains the complete methodology.

## Post-Init Steps

### Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r vendor-selection-evaluator/ ~/.claude/skills/vendor-selection-evaluator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions
4. Start with a prompt like: "Help me evaluate 3 vendors for [your need]"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `criterion_weight_cost` | `0.25` | Weight for cost criteria (0-1, must sum to 1.0) |
| `criterion_weight_quality` | `0.35` | Weight for quality criteria (0-1) |
| `criterion_weight_delivery` | `0.20` | Weight for delivery reliability (0-1) |
| `criterion_weight_strategic` | `0.20` | Weight for strategic fit (0-1) |
| `scoring_scale_max` | `5` | Maximum score in evaluation (5 or 10) |
| `risk_threshold` | `3.0` | Risk score above which mitigation is required |

## Weight Customization Examples

**Cost-Sensitive (Commodities):**
```
cost: 0.45, quality: 0.25, delivery: 0.20, strategic: 0.10
```

**Quality-Critical (Healthcare/Manufacturing):**
```
cost: 0.15, quality: 0.45, delivery: 0.20, strategic: 0.20
```

**Strategic Partnership (Technology):**
```
cost: 0.20, quality: 0.25, delivery: 0.20, strategic: 0.35
```

## Quick Start Prompts

After loading the skill, try:

1. **Initial Vendor Selection**
   ```
   I need to evaluate 3 cloud providers (AWS, Azure, GCP) for a 3-year
   enterprise commitment. Technical capability (30%), cost (25%),
   security compliance (25%), and AI roadmap alignment (20%).
   Create a weighted scorecard framework.
   ```

2. **Manufacturing Supplier**
   ```
   Build a supplier evaluation scorecard for injection molding vendors.
   Quality is most important (40%), then delivery (25%), cost (25%),
   and capacity (10%). Include defect rate and certification criteria.
   ```

3. **Vendor Performance Review**
   ```
   Design a quarterly performance scorecard for our existing logistics
   provider. Track on-time delivery, cost stability, issue resolution
   time, and capacity flexibility.
   ```

4. **TCO Comparison**
   ```
   Create a 3-year Total Cost of Ownership analysis template for
   comparing ERP vendors. Include implementation, training, support,
   integration, and hidden costs.
   ```

5. **Strategic Partnership**
   ```
   I'm evaluating digital transformation consulting firms for an
   18-month engagement. Strategic vision alignment and cultural fit
   are critical. Help me create a strategic partnership assessment.
   ```

## Methodology Summary

### Evaluation Framework
- **4 Pillars**: Cost, Quality, Delivery, Strategic Fit
- **Scoring**: 1-5 scale with documented evidence
- **Weighting**: Customizable based on procurement category
- **Output**: Ranked vendors with defensible decision rationale

### Decision Methods Supported
1. **WSM (Weighted Sum Model)** - Standard scorecard approach
2. **AHP (Analytical Hierarchy Process)** - For subjective criteria
3. **TOPSIS** - For ideal/anti-ideal comparison

### Risk Assessment
- Financial stability
- Operational continuity
- Compliance/security
- Concentration risk
- Key person dependency

## Integration with Other Skills

Works well with:
- **Vendor Risk Assessment** - Deeper compliance due diligence
- **Cost-Benefit Analysis** - Detailed financial comparison
- **Competitive Analysis** - Market positioning research

---
Downloaded from [Find Skill.ai](https://findskill.ai)
