---
name: ai-infographic-builder
version: 1.0.0
description: Create stunning infographics with AI tools — data visualization, layout design, and content structuring
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive infographic design framework covering 8 infographic types, data visualization selection, layout principles, color and typography guidelines, AI tool recommendations, and a complete creation workflow.

**Time to initialize**: ~5 minutes

## Directory Structure

```
ai-infographic-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Venngage, Piktochart, Canva, Napkin AI, Infogram, Visme, and other design tools.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your topic and key message
2. Choose the right infographic type
3. Organize your content into sections
4. Select visualizations for each data point
5. Use an AI tool to generate the layout

## Compatibility

Tested with: All AI assistants + Venngage, Piktochart, Canva, Napkin AI, Figma.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{topic}}` | `The State of Remote Work in 2026` | Infographic topic |
| `{{data_type}}` | `statistics and survey results` | Type of data |
| `{{audience}}` | `HR professionals and business leaders` | Target audience |
| `{{style}}` | `modern, clean, corporate with blue tones` | Visual style |
| `{{purpose}}` | `blog post and LinkedIn sharing` | Usage context |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
