---
name: ai-storyboard-creator
version: 1.0.0
description: Create professional storyboards with AI — scripts to visual panels with shot types, camera angles, and consistency techniques
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive storyboard creation system for films, commercials, animations, music videos, and social media content. Covers script breakdown, shot type selection, camera angle reference, AI prompt generation for Midjourney/DALL-E/Stable Diffusion, panel annotation, and project-specific workflows.

**Time to initialize**: ~5 minutes

## Directory Structure

```
ai-storyboard-creator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Midjourney, DALL-E, Stable Diffusion, Katalist, Boords, DrawStory, DomoAI, and any AI assistant for prompt generation.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Prepare your script excerpt or concept description
2. Use Phase 1 to break the script into story beats
3. Select shot types and camera angles with Phase 2 reference
4. Design each panel using the Phase 3 template
5. Generate AI prompts for your chosen tool (Phase 4)
6. Organize panels into a storyboard document (Phase 5)
7. Apply character consistency techniques (Phase 7)

### Key Principles

- Break scripts into beats first — each beat becomes 1-5 panels
- Lead AI prompts with shot type and camera angle for correct framing
- Maintain the 180-degree rule in dialogue scenes
- Use consistent --cref (Midjourney) or same-conversation (DALL-E) for character consistency
- Vary shot types between panels to avoid jump cuts
- Include full annotations: action, dialogue, SFX, transitions, duration

## Compatibility

Tested with: All AI assistants + Midjourney, DALL-E, Stable Diffusion, Katalist, Boords, DrawStory, DomoAI, Leonardo AI.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{project_type}}` | `a short film` | What the storyboards are for |
| `{{script_or_concept}}` | `A detective enters an abandoned warehouse...` | Script or concept |
| `{{visual_style}}` | `cinematic black and white with high contrast` | Art style |
| `{{panel_count}}` | `12-16 panels` | Number of panels |
| `{{ai_tool}}` | `Midjourney` | AI tool for generating visuals |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
