---
name: social-media-carousel-designer
version: 1.0.0
description: Design high-engagement carousel posts for Instagram, LinkedIn, TikTok, and Facebook
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive carousel design framework covering platform specs, content frameworks (educational, storytelling, comparison, before/after, data/stats, myth-busting), slide design principles, caption templates, and optimization strategies.

**Time to initialize**: ~5 minutes

## Directory Structure

```
social-media-carousel-designer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Canva, Figma, Adobe Express, aiCarousels.com, and any design tool.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Choose your topic and target platform
2. Select a content framework (educational, story, comparison, etc.)
3. Use the slide templates for structure
4. Apply design principles (one idea per slide, max 40 words)
5. Write your caption using platform-specific templates

## Compatibility

Tested with: All AI assistants + Canva, Figma, Adobe Express, and carousel-specific tools.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{topic}}` | `5 productivity tips for remote workers` | Carousel topic |
| `{{platform}}` | `Instagram` | Target platform |
| `{{goal}}` | `educate my audience and drive engagement` | Carousel goal |
| `{{brand_style}}` | `clean, modern, minimal with blue accent colors` | Visual style |
| `{{slide_count}}` | `8-10 slides` | Number of slides |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
