# Usability Heuristic Evaluator - Skill Instructions

## Overview
This skill enables AI assistants to perform systematic usability evaluations using Nielsen's 10 Usability Heuristics, providing structured feedback with severity ratings and actionable recommendations.

## Core Capabilities

### 1. Systematic Heuristic Evaluation
Analyzes UI designs against all 10 Nielsen heuristics plus 2 AI-specific heuristics:
- Visibility of system status
- Match between system and real world
- User control and freedom
- Consistency and standards
- Error prevention
- Recognition rather than recall
- Flexibility and efficiency of use
- Aesthetic and minimalist design
- Help users recognize, diagnose, recover from errors
- Help and documentation
- AI transparency (for AI interfaces)
- AI explainability (for AI interfaces)

### 2. Severity-Based Prioritization
Uses 0-4 scale to classify issues:
- **0**: Not a usability problem
- **1**: Cosmetic (fix if time permits)
- **2**: Minor (small friction point)
- **3**: Major (significant obstacle)
- **4**: Catastrophic (blocks task completion)

### 3. Multi-Screen Consistency Analysis
Evaluates consistency across multiple screens:
- Navigation patterns
- Terminology usage
- Visual design elements
- Interaction patterns

### 4. Structured Reporting
Generates comprehensive markdown reports with:
- Executive summary with issue counts
- Detailed findings by heuristic
- Prioritized action items
- Positive observations
- Next steps recommendations

## How to Use

### Step 1: Prepare Design Artifacts
Gather one or more of:
- Screenshots of UI screens
- Figma/Sketch/Adobe XD links
- Detailed text descriptions
- Interactive prototype URLs

### Step 2: Provide Context
Share with the AI:
- **Interface type**: Web app, mobile app, dashboard, etc.
- **User goals**: What tasks should users accomplish?
- **Target audience**: Who uses this interface?
- **Known constraints**: Technical limits, brand guidelines, etc.
- **Evaluation scope**: All heuristics or focused review?

### Step 3: Request Evaluation
Example prompts:
```
"Evaluate this checkout flow against Nielsen's heuristics [attach screenshots]"

"Perform a heuristic evaluation focusing on error prevention and recovery for this form design"

"Review this AI chatbot interface for usability issues, including AI-specific heuristics"

"Do a quick severity 3+ issues scan of this dashboard"
```

### Step 4: Receive Report
AI generates structured report with:
- Overall usability scores
- Specific violations by heuristic
- Severity ratings for each issue
- Actionable recommendations
- Prioritized fix list

### Step 5: Iterate
Follow up with:
```
"Can you elaborate on the error prevention issues?"

"What would a good solution look like for violation 2.3?"

"Evaluate these updated designs focusing on the critical issues you found"

"Compare this design variant against the original evaluation"
```

## Use Cases

### Design Review Sessions
**Scenario**: Weekly design critique meeting
**Usage**: Share prototype screens, get systematic feedback before stakeholder review
**Benefit**: Structured, evidence-based critique vs. subjective opinions

### Pre-Development QA
**Scenario**: Final design sign-off before engineering sprint
**Usage**: Full heuristic evaluation to catch issues before coding
**Benefit**: Cheaper to fix in design phase than post-development

### Competitive Analysis
**Scenario**: Benchmarking competitor products
**Usage**: Evaluate competitor interfaces to identify UX advantages/weaknesses
**Benefit**: Data-driven competitive insights

### Redesign Prioritization
**Scenario**: Limited resources for UX improvements
**Usage**: Identify and prioritize high-severity issues
**Benefit**: Focus effort on changes with biggest user impact

### AI Interface Validation
**Scenario**: Launching ML-powered feature
**Usage**: Evaluate with AI-specific heuristics (transparency, explainability)
**Benefit**: Ensure responsible AI implementation

### New Designer Onboarding
**Scenario**: Training junior UX designers
**Usage**: Use reports as learning examples
**Benefit**: Teaches systematic evaluation methodology

## Best Practices

### For Comprehensive Evaluations
1. **Provide multiple screens**: Enable consistency analysis
2. **Include user flows**: Show task progression across screens
3. **Share context**: Explain user goals and business requirements
4. **Request full report**: All heuristics for thorough coverage

### For Focused Reviews
1. **Specify heuristics**: "Just check error prevention"
2. **Set severity threshold**: "Only severity 3+ issues"
3. **Target specific components**: "Evaluate the navigation only"
4. **Time-box evaluation**: "Quick 15-minute scan"

### For Actionable Results
1. **Ask for examples**: "Show me what good error messages would look like"
2. **Request wireframes**: "Can you sketch the recommended fix?"
3. **Prioritize ruthlessly**: "If I can only fix 3 things, which ones?"
4. **Validate solutions**: "Does this address violation 4.2?"

### For Continuous Improvement
1. **Track over time**: Re-evaluate after fixes
2. **Document decisions**: Note why certain issues weren't fixed
3. **Share learnings**: Use reports in design system documentation
4. **Automate checks**: Build heuristics into design checklist

## Integration with Design Workflow

### Discovery Phase
- Evaluate competitor products
- Identify industry best practices
- Document usability benchmarks

### Ideation Phase
- Quick heuristic checks on early sketches
- Validate concept against known pitfalls
- Compare design alternatives

### Design Phase
- Systematic wireframe review
- Prototype usability evaluation
- Consistency checks across flows

### Development Phase
- Pre-development final review
- Implementation QA testing
- Regression testing for new features

### Post-Launch Phase
- Identify improvement opportunities
- Prioritize backlog items
- Validate redesign effectiveness

## Common Evaluation Patterns

### Pattern 1: Full Interface Audit
```
User: "Here are 12 screens from our admin dashboard [screenshots]"
AI: Performs complete evaluation
- All 10 heuristics checked
- Consistency analysis across all screens
- Prioritized master list of issues
- Executive summary for stakeholders
```

### Pattern 2: Problem-Focused Deep Dive
```
User: "Users are making lots of errors on this form"
AI: Focused evaluation
- Deep analysis of Heuristics #5 (Error Prevention) and #9 (Error Recovery)
- Specific form field recommendations
- Examples of improved error messages
- Validation strategy suggestions
```

### Pattern 3: Quick Pre-Meeting Scan
```
User: "Design review in 30 min, any critical issues? [2 screens]"
AI: Rapid assessment
- Severity 3-4 issues only
- Top 5 priority fixes
- Quick recommendations
- No detailed report
```

### Pattern 4: Comparative Evaluation
```
User: "Which design is better? [Option A vs Option B screenshots]"
AI: Comparative analysis
- Side-by-side heuristic scores
- Specific advantages of each
- Hybrid recommendations
- Decision framework
```

### Pattern 5: Accessibility-Enhanced Review
```
User: "Evaluate this including accessibility concerns"
AI: Extended evaluation
- Standard 10 heuristics
- Additional accessibility notes (color contrast, keyboard nav, screen readers)
- WCAG quick reference
- Combined priority list
```

## Output Customization

### Report Length
- **Executive Summary Only**: High-level scores + top 3 issues
- **Standard Report**: Full heuristic breakdown with recommendations
- **Detailed Analysis**: Includes examples, mockups, research citations

### Focus Areas
- **All Heuristics**: Comprehensive coverage
- **Specific Heuristics**: "Just #3, #5, and #9"
- **Severity Threshold**: "Only severity 2 and above"
- **Component-Specific**: "Evaluate the checkout button only"

### Audience Adaptation
- **For Designers**: Detailed UX terminology, design examples
- **For Developers**: Implementation-focused recommendations
- **For Stakeholders**: Business impact framing, ROI considerations
- **For QA Teams**: Test case suggestions, acceptance criteria

## Tips for Maximum Value

### Before Evaluation
✅ **DO**: Provide clear screenshots with labels
✅ **DO**: Explain user goals and context
✅ **DO**: Specify any known constraints
❌ **DON'T**: Submit blurry or partial screenshots
❌ **DON'T**: Assume AI knows your business domain
❌ **DON'T**: Skip context about target users

### During Evaluation
✅ **DO**: Ask clarifying questions
✅ **DO**: Request examples and alternatives
✅ **DO**: Challenge findings if they seem off
❌ **DON'T**: Accept every finding blindly
❌ **DON'T**: Ignore business/technical constraints
❌ **DON'T**: Try to fix everything at once

### After Evaluation
✅ **DO**: Prioritize based on severity + business impact
✅ **DO**: Validate fixes with users if possible
✅ **DO**: Re-evaluate after implementing changes
❌ **DON'T**: Treat report as final arbiter
❌ **DON'T**: Ignore low-severity issues forever
❌ **DON'T**: Skip celebrating UX wins

## Limitations to Understand

### What This Skill Does Well
- Systematic evaluation against proven heuristics
- Consistent, objective analysis framework
- Identifies common usability problems
- Provides structured prioritization
- Scales to complex interfaces

### What This Skill Cannot Do
- Replace real user testing
- Account for unique user mental models
- Evaluate subjective aesthetic preferences
- Test actual task performance
- Measure emotional responses
- Validate business value of features

### Recommended Complementary Methods
- **User Testing**: Validate findings with real users
- **Analytics Review**: Check if issues impact metrics
- **Accessibility Audit**: WCAG compliance checking
- **A/B Testing**: Measure impact of fixes
- **Card Sorting**: Information architecture validation
- **Surveys**: Gather user satisfaction data

## Advanced Usage

### Creating Custom Heuristics
For specialized domains, add custom heuristics:
```
"Use standard heuristics plus these 3 domain-specific ones:
- Medical accuracy and safety
- HIPAA compliance indicators
- Clinical workflow efficiency"
```

### Batch Evaluation
Process multiple designs efficiently:
```
"Evaluate 5 competitor checkout flows and create comparative matrix"
```

### Trend Analysis
Track improvement over time:
```
"Compare this evaluation to the one from last month - what improved?"
```

### Design System Validation
Check pattern library consistency:
```
"Evaluate all 15 components in our design system for heuristic compliance"
```

## Example Interaction Flow

```
Designer: "I need to evaluate our new mobile app onboarding flow before we ship.
Here are 6 screens [attaches screenshots]. Target users are first-time investors,
ages 25-40. Main goal is to create account and link bank account."

AI: "I'll perform a comprehensive heuristic evaluation of your 6-screen onboarding
flow. Let me analyze each screen against all 10 Nielsen heuristics plus check for
consistency across the flow.

[Generates full report]

# Usability Heuristic Evaluation Report

## Executive Summary
- **Critical Issues (Severity 4):** 1
- **Major Issues (Severity 3):** 4
- **Minor Issues (Severity 2):** 7
- **Cosmetic Issues (Severity 1):** 3

### Top 3 Priority Fixes
1. [Critical] Screen 4: Bank linking has no back button (Heuristic #3: User Control)
2. [Major] Screen 2: Password requirements hidden until error (Heuristic #5: Error Prevention)
3. [Major] Inconsistent "Next" button placement across screens (Heuristic #4: Consistency)

[... detailed findings follow ...]"

Designer: "That critical issue with the back button - what's the best way to fix it?"

AI: "For the bank linking screen back button issue, I recommend:

**Option 1: Standard Back Navigation (Recommended)**
- Add persistent back arrow in top-left corner
- Consistent with other screens in the flow
- Include confirmation dialog: 'Progress will be saved. Return to previous step?'
- Preserves any partial data entered

**Option 2: Progress Indicator with Navigation**
- Add stepped progress bar at top (Step 4 of 6)
- Make previous steps tappable to navigate back
- More visibility of overall progress
- Slightly more complex to implement

**Option 3: Explicit 'Save and Exit' Button**
- Add secondary 'Save and Come Back Later' option
- Provides clear exit path
- Good for lengthy forms
- Requires session management

I recommend Option 1 for quickest fix that solves the critical issue. Option 2 would
also address Minor Issue 2.4 about progress visibility. Would you like me to sketch
what this would look like?"

Designer: "Yes, please sketch Option 2."

AI: [Provides ASCII wireframe or description of implementation]
```

## Skill Maintenance

This skill is based on:
- Nielsen Norman Group's 10 Usability Heuristics (1994, revised 2020)
- ISO 9241-110:2020 Ergonomics of human-system interaction
- Additional AI-specific heuristics from recent UX research

The framework is stable and widely adopted. Updates to this skill would primarily involve:
- Adding emerging heuristics for new technologies (VR/AR, voice UI)
- Expanding severity rating guidance
- Including more industry-specific customizations
- Adding visual examples library

## Related Resources

### Complementary Skills
- **Accessibility Audit**: WCAG compliance checking
- **User Flow Analysis**: End-to-end journey mapping
- **Design System Review**: Component library consistency
- **A/B Test Analyzer**: Quantitative validation of UX changes

### External Learning
- Nielsen Norman Group: Free articles on heuristic evaluation
- NN/g UX Conference: Heuristic evaluation workshops
- "Usability Engineering" by Jakob Nielsen (book)
- Baymard Institute: UX research with heuristic frameworks

---

**Skill Version**: 1.0
**Last Updated**: 2025-09-18
**Skill Type**: UX/UI Evaluation
**Complexity**: Intermediate
**Estimated Evaluation Time**:
- Single screen: 5-10 minutes
- Complete flow (5-10 screens): 20-30 minutes
- Full application audit: 1-3 hours
