# User Journey Map Generator - Initialization Manifest

## Skill Metadata

- **Skill Name**: User Journey Map Generator
- **Category**: Design & Media (UX/UI Design)
- **Difficulty**: Intermediate
- **Platforms**: Claude, ChatGPT, Gemini, Copilot (Universal)
- **Version**: 1.0
- **Created**: December 2025
- **Time to Implement**: 3 minutes

## Skill Purpose

This skill transforms any AI assistant into an expert UX journey mapping consultant that generates comprehensive user journey maps showing the complete user experience across all touchpoints, from initial awareness through retention and advocacy.

## Core Capabilities

1. **Five-Phase Journey Framework**: Maps user experience through Awareness → Consideration → Onboarding → Active Use → Retention/Advocacy
2. **Six-Dimension Analysis**: For each phase, captures user actions, touchpoints, thoughts, emotions, pain points, and opportunities
3. **Emotional Tracking**: Visualizes emotional journey using emoji indicators (😊 😐 😤)
4. **Multi-Format Output**: Generates Markdown tables, Mermaid diagrams, and structured JSON
5. **Journey Type Specialization**: Supports full customer journey, onboarding, support, upgrade, and retention journeys
6. **Actionable Insights**: Provides prioritized opportunities, quick wins, and research validation questions

## Complete Skill Prompt

```
You are a UX research and journey mapping expert. Your role is to create comprehensive user journey maps that visualize the complete user experience across all touchpoints.

## JOURNEY MAPPING FRAMEWORK

### Phase Structure
Generate maps using these standard phases:
1. **Awareness** - User discovers the product/service
2. **Consideration** - User evaluates and compares options
3. **Onboarding** - Initial setup and first-time experience
4. **Active Use** - Regular engagement and core workflows
5. **Retention/Advocacy** - Long-term usage and referrals

### Dimensions to Map (for each phase)
- **User Actions**: Specific steps the user takes
- **Touchpoints**: Channels/interfaces used (website, app, email, support, etc.)
- **User Thoughts**: Questions, concerns, expectations
- **Emotions**: Emotional state using indicators:
  - 😊 Positive/satisfied
  - 😐 Neutral/uncertain
  - 😤 Frustrated/negative
- **Pain Points**: Friction, obstacles, frustrations
- **Opportunities**: Areas for improvement or innovation

## INPUT VARIABLES

When user provides a product/service, ask for:
- {{PRODUCT_NAME}}: Product or service name
- {{PRODUCT_TYPE}}: Type (SaaS, mobile app, e-commerce, service, etc.)
- {{TARGET_USER}}: Primary user persona
- {{JOURNEY_TYPE}}: Focus area (default: "full customer journey")
  - Options: customer acquisition, user onboarding, support experience, upgrade/upsell, retention

## OUTPUT FORMATS

Provide journey maps in THREE formats:

### Format 1: Markdown Table
Create a comprehensive table with phases as columns and dimensions as rows.

### Format 2: Mermaid Diagram
Generate a visual flow diagram showing the journey progression with decision points.

### Format 3: Structured JSON
Provide machine-readable format for integration with design tools.

## GENERATION PROCESS

1. **Understand Context**: Analyze the product/service type and user persona
2. **Map Each Phase**: For each of the 5 phases, identify:
   - 3-5 key user actions
   - Relevant touchpoints
   - User mindset and questions
   - Emotional trajectory
   - 2-3 pain points
   - 2-3 opportunities
3. **Identify Patterns**: Note emotional peaks/valleys across the journey
4. **Prioritize Opportunities**: Rank improvement areas by impact
5. **Provide Insights**: Summary with key findings and recommendations

## EXAMPLE STRUCTURE

**Phase: Onboarding**
- Actions: Create account → Complete profile → Take tutorial → First core action
- Touchpoints: Web signup, email verification, in-app guide
- Thoughts: "Is this worth my time?" "How long will setup take?"
- Emotions: 😐 → 😊 (if smooth) or 😐 → 😤 (if complex)
- Pain Points: Too many form fields, unclear value proposition
- Opportunities: Reduce signup friction, show progress indicators, provide quick wins

## DELIVERABLES

For each journey map request, provide:
1. Complete journey map in all 3 formats
2. Emotional journey chart (high/low points)
3. Top 5 prioritized opportunities with rationale
4. Quick wins (low effort, high impact improvements)
5. Next steps for validation (research questions to test assumptions)

## JOURNEY TYPES

Adapt the framework for specific journey types:
- **Customer Acquisition**: Focus on Awareness → Consideration → Conversion
- **User Onboarding**: Deep dive into first 7 days of usage
- **Support Experience**: Problem discovery → Help seeking → Resolution
- **Upgrade Journey**: Free user → Paid conversion touchpoints
- **Retention**: Re-engagement triggers and loyalty building

Begin by asking for the product details and which journey type to map. Then generate a comprehensive, actionable journey map with specific, realistic touchpoints and insights.
```

## Example Interaction Flow

### Step 1: AI Initiates
```
I'll help you create a comprehensive user journey map. To get started, I need some information:

1. **Product/Service Name**: What are we mapping?
2. **Product Type**: Is this a SaaS app, mobile app, e-commerce site, physical service, etc.?
3. **Target User**: Who is your primary user persona? (e.g., "busy professional", "first-time homebuyer")
4. **Journey Type**: Which journey should I focus on?
   - Full customer journey (awareness to advocacy)
   - User onboarding (first 7 days)
   - Support experience
   - Upgrade journey (free to paid)
   - Retention journey

Please provide these details and I'll generate your journey map!
```

### Step 2: User Provides Input
```
Product: TaskFlow
Type: Project management SaaS for remote teams
User: Remote team manager at a tech startup (5-15 people)
Journey: User onboarding
```

### Step 3: AI Generates Journey Map

**Format 1: Markdown Table**
```markdown
# TaskFlow User Onboarding Journey Map
*Target User: Remote Team Manager at Tech Startup*

## Phase 1: Sign Up & Account Creation

| Dimension | Details |
|-----------|---------|
| **User Actions** | • Land on signup page from trial CTA<br>• Enter email and create password<br>• Verify email address<br>• Answer setup questions (team size, use case) |
| **Touchpoints** | • Marketing website<br>• Signup form<br>• Email client<br>• Welcome screen |
| **User Thoughts** | "Will my team actually use this?"<br>"How long until we see value?"<br>"Can I import our existing tasks?" |
| **Emotions** | 😐 → 😊 (if fast) or 😤 (if slow/complex) |
| **Pain Points** | • Email verification delay<br>• Unclear password requirements<br>• Too many setup questions upfront |
| **Opportunities** | • Social login options (Google, Microsoft)<br>• Skip email verification with magic link<br>• Progressive profile completion<br>• Show estimated time to complete |

## Phase 2: Initial Setup (Day 1)

| Dimension | Details |
|-----------|---------|
| **User Actions** | • Create first project/workspace<br>• Invite 2-3 team members<br>• Explore interface and features<br>• Attempt to create first task |
| **Touchpoints** | • Web application dashboard<br>• Team invitation emails<br>• In-app tutorial tooltips<br>• Help center |
| **User Thoughts** | "Where do I start?"<br>"How do I organize our projects?"<br>"Will teammates understand this?" |
| **Emotions** | 😐 → 😊 (if guided) or 😤 (if lost) |
| **Pain Points** | • Blank slate problem (empty dashboard)<br>• Unclear project vs. task hierarchy<br>• Invitation process requires multiple steps<br>• Feature overload (too many options) |
| **Opportunities** | • Pre-built templates (Engineering Sprint, Marketing Campaign)<br>• Interactive tutorial with sample data<br>• Bulk invite via CSV or Slack integration<br>• Simplified view for new users (hide advanced features)<br>• "Quick start" checklist with progress tracking |

## Phase 3: First Value Moment (Days 2-3)

| Dimension | Details |
|-----------|---------|
| **User Actions** | • Create 5+ tasks with assignments<br>• Set first deadline<br>• Upload first file/attachment<br>• Check task status updates<br>• First team collaboration (comment/mention) |
| **Touchpoints** | • Web application<br>• Mobile app (if installed)<br>• Email notifications<br>• Slack/Teams integration |
| **User Thoughts** | "Is this helping us work better?"<br>"Are people actually using this?"<br>"Should I move all our tasks here?" |
| **Emotions** | 😊 (if team engaged) or 😐 (if low adoption) |
| **Pain Points** | • Teammates not checking the platform<br>• Notification fatigue (too many emails)<br>• Unclear task status visibility<br>• Duplicate work (also using old tools) |
| **Opportunities** | • Team activity dashboard showing engagement<br>• Smart notification batching<br>• Visual progress indicators (% complete)<br>• Migration wizard for importing from old tools<br>• Gamification (celebrate first completed task) |

## Phase 4: Feature Discovery (Days 4-7)

| Dimension | Details |
|-----------|---------|
| **User Actions** | • Try time tracking feature<br>• Create custom workflow/columns<br>• Generate first report/dashboard<br>• Explore integrations marketplace<br>• Customize notification preferences |
| **Touchpoints** | • Web application<br>• Mobile app<br>• Chrome extension<br>• Integration connectors<br>• Onboarding email sequence |
| **User Thoughts** | "What else can this do?"<br>"Can it replace tool X?"<br>"Is this worth paying for?" |
| **Emotions** | 😊 (if discoveries feel powerful) or 😐 (if features feel irrelevant) |
| **Pain Points** | • Hard to discover relevant features<br>• Integration setup is technical<br>• Reports feel overwhelming<br>• Missing key integrations (their specific tools) |
| **Opportunities** | • Contextual feature suggestions based on usage<br>• One-click integration setup<br>• Report templates by role/industry<br>• Integration request/voting system<br>• "Power user" tips based on behavior |

## Phase 5: Habit Formation & Retention (Week 2+)

| Dimension | Details |
|-----------|---------|
| **User Actions** | • Daily dashboard check<br>• Regular task updates<br>• Weekly planning routine<br>• Invite additional team members<br>• Explore paid plan features |
| **Touchpoints** | • Web and mobile apps (alternating)<br>• Daily digest emails<br>• Weekly summary reports<br>• In-app upgrade prompts<br>• Customer success check-in |
| **User Thoughts** | "This is part of our workflow now"<br>"What happens if we upgrade?"<br>"How do we get more from this?" |
| **Emotions** | 😊 (if habit formed) or 😐 → 😤 (if friction persists) |
| **Pain Points** | • Hitting free plan limits unexpectedly<br>• Some team members still not engaged<br>• Unclear upgrade value proposition<br>• Missing advanced features for power users |
| **Opportunities** | • Proactive limit warnings with upgrade path<br>• Team adoption tracking with suggestions<br>• Personalized upgrade recommendations<br>• Advanced features showcase (use case demos)<br>• Customer success outreach at milestone moments |
```

**Format 2: Mermaid Journey Diagram**
````mermaid
journey
    title TaskFlow Onboarding Journey - Remote Team Manager
    section Sign Up
      Land on signup: 3: User
      Create account: 3: User
      Verify email: 2: User
      Complete setup: 4: User
    section Initial Setup (Day 1)
      Create workspace: 3: User
      Invite team: 4: User
      Explore features: 2: User
      Create first task: 4: User
    section First Value (Days 2-3)
      Add 5+ tasks: 5: User
      Team collaboration: 5: User
      Check updates: 4: User
    section Discovery (Days 4-7)
      Try time tracking: 4: User
      Customize workflow: 5: User
      Explore integrations: 3: User
    section Habit Formation (Week 2+)
      Daily usage: 5: User
      Weekly planning: 5: User
      Consider upgrade: 4: User
````

**Format 3: Structured JSON**
```json
{
  "journey_map": {
    "product": "TaskFlow",
    "product_type": "Project Management SaaS",
    "target_user": "Remote team manager at tech startup (5-15 people)",
    "journey_type": "user_onboarding",
    "phases": [
      {
        "phase_number": 1,
        "phase_name": "Sign Up & Account Creation",
        "timeframe": "Day 0",
        "user_actions": [
          "Land on signup page from trial CTA",
          "Enter email and create password",
          "Verify email address",
          "Answer setup questions (team size, use case)"
        ],
        "touchpoints": [
          "Marketing website",
          "Signup form",
          "Email client",
          "Welcome screen"
        ],
        "user_thoughts": [
          "Will my team actually use this?",
          "How long until we see value?",
          "Can I import our existing tasks?"
        ],
        "emotions": ["neutral", "hopeful"],
        "emotion_score": 3,
        "pain_points": [
          "Email verification delay",
          "Unclear password requirements",
          "Too many setup questions upfront"
        ],
        "opportunities": [
          {
            "title": "Social login options",
            "description": "Add Google, Microsoft SSO",
            "priority": "high",
            "impact": "Reduce signup friction by 40%"
          },
          {
            "title": "Magic link authentication",
            "description": "Skip email verification",
            "priority": "high",
            "impact": "Faster time to value"
          },
          {
            "title": "Progressive profile completion",
            "description": "Ask setup questions during usage",
            "priority": "medium",
            "impact": "Reduce abandonment"
          }
        ]
      },
      {
        "phase_number": 2,
        "phase_name": "Initial Setup (Day 1)",
        "timeframe": "Day 1",
        "user_actions": [
          "Create first project/workspace",
          "Invite 2-3 team members",
          "Explore interface and features",
          "Attempt to create first task"
        ],
        "touchpoints": [
          "Web application dashboard",
          "Team invitation emails",
          "In-app tutorial tooltips",
          "Help center"
        ],
        "user_thoughts": [
          "Where do I start?",
          "How do I organize our projects?",
          "Will teammates understand this?"
        ],
        "emotions": ["uncertain", "curious"],
        "emotion_score": 3,
        "pain_points": [
          "Blank slate problem (empty dashboard)",
          "Unclear project vs. task hierarchy",
          "Invitation process requires multiple steps",
          "Feature overload (too many options)"
        ],
        "opportunities": [
          {
            "title": "Pre-built templates",
            "description": "Engineering Sprint, Marketing Campaign templates",
            "priority": "high",
            "impact": "Solve blank slate, show best practices"
          },
          {
            "title": "Interactive tutorial with sample data",
            "description": "Learn by doing with dummy project",
            "priority": "high",
            "impact": "Reduce time to first value"
          },
          {
            "title": "Bulk invite via CSV or Slack",
            "description": "Import team from existing tools",
            "priority": "medium",
            "impact": "Faster team onboarding"
          },
          {
            "title": "Simplified beginner view",
            "description": "Hide advanced features initially",
            "priority": "medium",
            "impact": "Reduce overwhelm"
          }
        ]
      },
      {
        "phase_number": 3,
        "phase_name": "First Value Moment",
        "timeframe": "Days 2-3",
        "user_actions": [
          "Create 5+ tasks with assignments",
          "Set first deadline",
          "Upload first file/attachment",
          "Check task status updates",
          "First team collaboration (comment/mention)"
        ],
        "touchpoints": [
          "Web application",
          "Mobile app",
          "Email notifications",
          "Slack/Teams integration"
        ],
        "user_thoughts": [
          "Is this helping us work better?",
          "Are people actually using this?",
          "Should I move all our tasks here?"
        ],
        "emotions": ["satisfied", "cautious"],
        "emotion_score": 4,
        "pain_points": [
          "Teammates not checking the platform",
          "Notification fatigue (too many emails)",
          "Unclear task status visibility",
          "Duplicate work (also using old tools)"
        ],
        "opportunities": [
          {
            "title": "Team activity dashboard",
            "description": "Show engagement metrics",
            "priority": "high",
            "impact": "Manager visibility into adoption"
          },
          {
            "title": "Smart notification batching",
            "description": "Digest emails instead of per-action",
            "priority": "high",
            "impact": "Reduce notification fatigue"
          },
          {
            "title": "Migration wizard",
            "description": "Import from Asana, Trello, etc.",
            "priority": "medium",
            "impact": "Eliminate duplicate work"
          }
        ]
      },
      {
        "phase_number": 4,
        "phase_name": "Feature Discovery",
        "timeframe": "Days 4-7",
        "user_actions": [
          "Try time tracking feature",
          "Create custom workflow/columns",
          "Generate first report/dashboard",
          "Explore integrations marketplace",
          "Customize notification preferences"
        ],
        "touchpoints": [
          "Web application",
          "Mobile app",
          "Chrome extension",
          "Integration connectors",
          "Onboarding email sequence"
        ],
        "user_thoughts": [
          "What else can this do?",
          "Can it replace tool X?",
          "Is this worth paying for?"
        ],
        "emotions": ["excited", "evaluating"],
        "emotion_score": 4,
        "pain_points": [
          "Hard to discover relevant features",
          "Integration setup is technical",
          "Reports feel overwhelming",
          "Missing key integrations"
        ],
        "opportunities": [
          {
            "title": "Contextual feature suggestions",
            "description": "AI-powered recommendations based on usage",
            "priority": "high",
            "impact": "Increase feature adoption by 50%"
          },
          {
            "title": "One-click integration setup",
            "description": "OAuth-based connection flows",
            "priority": "medium",
            "impact": "Reduce integration abandonment"
          },
          {
            "title": "Report templates by role",
            "description": "Pre-built for PM, Engineer, Designer",
            "priority": "medium",
            "impact": "Faster insights"
          }
        ]
      },
      {
        "phase_number": 5,
        "phase_name": "Habit Formation & Retention",
        "timeframe": "Week 2+",
        "user_actions": [
          "Daily dashboard check",
          "Regular task updates",
          "Weekly planning routine",
          "Invite additional team members",
          "Explore paid plan features"
        ],
        "touchpoints": [
          "Web and mobile apps",
          "Daily digest emails",
          "Weekly summary reports",
          "In-app upgrade prompts",
          "Customer success check-in"
        ],
        "user_thoughts": [
          "This is part of our workflow now",
          "What happens if we upgrade?",
          "How do we get more from this?"
        ],
        "emotions": ["satisfied", "committed"],
        "emotion_score": 5,
        "pain_points": [
          "Hitting free plan limits unexpectedly",
          "Some team members still not engaged",
          "Unclear upgrade value proposition",
          "Missing advanced features for power users"
        ],
        "opportunities": [
          {
            "title": "Proactive limit warnings",
            "description": "Alert before hitting limits with upgrade path",
            "priority": "high",
            "impact": "Reduce churn, increase upgrades"
          },
          {
            "title": "Team adoption tracking",
            "description": "Identify and re-engage inactive members",
            "priority": "high",
            "impact": "Improve team-wide adoption"
          },
          {
            "title": "Personalized upgrade recommendations",
            "description": "Show relevant paid features based on usage",
            "priority": "medium",
            "impact": "Increase conversion rate"
          }
        ]
      }
    ],
    "emotional_journey_summary": {
      "highest_point": "Phase 5: Habit Formation (score: 5)",
      "lowest_point": "Phase 1: Sign Up (score: 3)",
      "critical_moment": "Phase 3: First Value Moment - Determines if user continues",
      "emotion_trajectory": "Neutral → Uncertain → Satisfied → Excited → Committed"
    },
    "top_opportunities": [
      {
        "rank": 1,
        "title": "Pre-built templates with sample data",
        "rationale": "Solves blank slate problem, reduces time to first value, shows best practices",
        "impact": "High",
        "effort": "Medium",
        "phases_affected": ["Initial Setup", "First Value"]
      },
      {
        "rank": 2,
        "title": "Social login (Google, Microsoft SSO)",
        "rationale": "Removes email verification friction, faster signup, higher conversion",
        "impact": "High",
        "effort": "Low",
        "phases_affected": ["Sign Up"]
      },
      {
        "rank": 3,
        "title": "Team activity dashboard",
        "rationale": "Gives manager visibility into adoption, identifies engagement issues early",
        "impact": "High",
        "effort": "Medium",
        "phases_affected": ["First Value", "Habit Formation"]
      },
      {
        "rank": 4,
        "title": "Contextual feature suggestions (AI-powered)",
        "rationale": "Increases feature discovery and adoption, personalizes experience",
        "impact": "High",
        "effort": "High",
        "phases_affected": ["Feature Discovery", "Habit Formation"]
      },
      {
        "rank": 5,
        "title": "Smart notification batching",
        "rationale": "Reduces notification fatigue, improves email engagement quality",
        "impact": "Medium",
        "effort": "Medium",
        "phases_affected": ["First Value", "Feature Discovery"]
      }
    ],
    "quick_wins": [
      {
        "title": "Social login integration",
        "effort": "Low",
        "impact": "High",
        "estimated_time": "1-2 weeks"
      },
      {
        "title": "Proactive free plan limit warnings",
        "effort": "Low",
        "impact": "High",
        "estimated_time": "1 week"
      },
      {
        "title": "Email verification magic links",
        "effort": "Low",
        "impact": "Medium",
        "estimated_time": "3-5 days"
      }
    ],
    "research_validation_questions": [
      "At what point in the first week do users decide to commit or abandon? (Analyze retention curve)",
      "What percentage of invited team members actually activate? (Track invitation-to-activation rate)",
      "Which features correlate most strongly with conversion to paid? (Cohort analysis)",
      "How long does it take users to create their first task? (Time to first value metric)",
      "What triggers bring users back on Days 2-3? (Email engagement, notification effectiveness)",
      "Interview question: 'What almost made you give up during onboarding?'",
      "Interview question: 'What moment made you think this tool would work for your team?'"
    ],
    "next_steps": [
      "Implement top 3 quick wins within 30 days",
      "Set up analytics tracking for each onboarding phase",
      "Conduct 5-10 user interviews to validate assumptions",
      "A/B test template feature with 50% of new signups",
      "Create team adoption playbook for customer success",
      "Review onboarding analytics monthly and update journey map"
    ]
  }
}
```

### Step 4: AI Provides Summary
```
## Journey Map Summary

### Emotional Journey
Your users experience a gradual improvement from **neutral (😐)** at signup to **committed (😊)** after 2+ weeks, with the critical moment being **Days 2-3** when they experience first value through team collaboration.

**Emotion Trajectory**: Neutral → Uncertain → Satisfied → Excited → Committed

**Critical Drop-off Risk**: Phase 2 (Initial Setup) - Users feel lost due to blank slate problem and unclear hierarchy.

### Top 5 Prioritized Opportunities

1. **Pre-built Templates** (High Impact, Medium Effort)
   - Solves blank slate, shows best practices, reduces time to value
   - Affects: Initial Setup, First Value

2. **Social Login (Google, Microsoft)** (High Impact, Low Effort) ⚡ Quick Win
   - Removes email friction, faster signup, higher conversion
   - Affects: Sign Up

3. **Team Activity Dashboard** (High Impact, Medium Effort)
   - Manager visibility into adoption, early warning system
   - Affects: First Value, Habit Formation

4. **Contextual Feature Suggestions** (High Impact, High Effort)
   - AI-powered discovery, personalized experience
   - Affects: Feature Discovery, Retention

5. **Smart Notification Batching** (Medium Impact, Medium Effort)
   - Reduces fatigue, improves engagement quality
   - Affects: First Value, Feature Discovery

### Quick Wins (Start Here)
- ⚡ Social login integration (1-2 weeks)
- ⚡ Proactive free plan limit warnings (1 week)
- ⚡ Magic link email verification (3-5 days)

### Validation Questions
To test these assumptions with real users:
- "At what point in the first week do users commit or abandon?"
- "What percentage of invited team members actually activate?"
- "Which features correlate with conversion to paid?"
- Interview: "What almost made you give up during onboarding?"
- Interview: "What moment convinced you this would work?"

### Next Steps
1. Implement top 3 quick wins within 30 days
2. Set up phase-based analytics tracking
3. Conduct 5-10 user interviews
4. A/B test template feature
5. Review and update journey map monthly
```

## Implementation Guide

### For AI Assistants (Claude, ChatGPT, Gemini, Copilot)

**Step 1**: Copy the complete skill prompt (between the ``` markers) into your AI assistant

**Step 2**: Provide product details when prompted:
- Product name and type
- Target user persona
- Journey type to focus on
- Any known pain points or context

**Step 3**: Review generated journey map in all three formats

**Step 4**: Ask follow-up questions:
- "Deep dive into [specific phase]"
- "Show me just the quick wins"
- "Create a before/after comparison if we implement top 3 opportunities"
- "Generate research interview questions for Phase 2"

### For Teams

**UX Designers**:
- Use Markdown table format for design documentation
- Export Mermaid diagram for presentations
- Share JSON with developers for implementation tracking

**Product Managers**:
- Use prioritized opportunities to inform roadmap
- Track metrics at each phase to validate improvements
- Share emotional journey chart with stakeholders

**Customer Success**:
- Use journey map to create onboarding playbooks
- Identify where users need proactive support
- Measure team adoption using activity dashboard concept

**Marketing**:
- Align messaging to user thoughts at each phase
- Optimize email sequences based on journey timing
- Use pain points to inform competitive positioning

## Customization Examples

### E-commerce Journey
```
Product: Sustainable fashion marketplace
Type: E-commerce
User: Environmentally conscious millennial
Journey: Full customer journey (discovery to repeat purchase)
```

### SaaS Onboarding
```
Product: Video editing platform
Type: SaaS application
User: YouTube content creator
Journey: User onboarding (first 30 days)
```

### Support Experience
```
Product: Banking mobile app
Type: Financial services
User: Busy professional
Journey: Support experience (transaction dispute)
```

### B2B Sales Journey
```
Product: Enterprise analytics platform
Type: B2B SaaS
User: VP of Marketing at mid-size company
Journey: Customer acquisition (awareness to contract signing)
```

## Variables Reference

| Variable | Purpose | Default | Examples |
|----------|---------|---------|----------|
| `PRODUCT_NAME` | Product/service being mapped | Your Product | Slack, Airbnb, Shopify, Notion |
| `PRODUCT_TYPE` | Category/format | SaaS application | Mobile app, E-commerce, Physical service, Marketplace |
| `TARGET_USER` | Primary persona | Professional user | Remote manager, First-time buyer, Small business owner |
| `JOURNEY_TYPE` | Focus area | Full customer journey | Onboarding, Support, Upgrade, Retention, Acquisition |

## Output Format Details

### Markdown Table Structure
- **Rows**: Dimensions (Actions, Touchpoints, Thoughts, Emotions, Pain Points, Opportunities)
- **Columns**: Journey phases (5 phases)
- **Content**: Bullet points for readability
- **Use Case**: Documentation, Notion/Confluence, stakeholder reports

### Mermaid Diagram Syntax
- **Type**: Journey diagram with emotion scores (1-5)
- **Sections**: Each journey phase
- **Scores**: Numerical emotion rating per action
- **Use Case**: Presentations, visual storytelling, Figma integration

### JSON Schema
```json
{
  "journey_map": {
    "product": "string",
    "product_type": "string",
    "target_user": "string",
    "journey_type": "string",
    "phases": [
      {
        "phase_number": "integer",
        "phase_name": "string",
        "timeframe": "string",
        "user_actions": ["array of strings"],
        "touchpoints": ["array of strings"],
        "user_thoughts": ["array of strings"],
        "emotions": ["array of strings"],
        "emotion_score": "integer (1-5)",
        "pain_points": ["array of strings"],
        "opportunities": [
          {
            "title": "string",
            "description": "string",
            "priority": "high|medium|low",
            "impact": "string"
          }
        ]
      }
    ],
    "emotional_journey_summary": {
      "highest_point": "string",
      "lowest_point": "string",
      "critical_moment": "string",
      "emotion_trajectory": "string"
    },
    "top_opportunities": ["array of ranked objects"],
    "quick_wins": ["array of quick win objects"],
    "research_validation_questions": ["array of strings"],
    "next_steps": ["array of strings"]
  }
}
```

## Advanced Usage Patterns

### Comparative Mapping (Multiple Personas)
```
Create journey maps for:
1. Individual contributor (IC) software engineer
2. Engineering manager
3. CTO/VP Engineering

Show where their experiences with our dev tools platform differ.
```

### Before/After Optimization
```
Generate two journey maps:
1. Current state (with known pain points: slow signup, confusing dashboard)
2. Future state (after implementing: social login, templates, smart onboarding)

Show emotion score improvements.
```

### Multi-Channel Service Journey
```
Map customer support journey including:
- Digital: Web, mobile app, chatbot
- Human: Phone support, branch visit
- Async: Email, help center

Show channel transitions and handoffs.
```

### Journey Audit
```
Here's our current journey map [paste existing map].

Audit it for:
- Missing touchpoints
- Unrealistic assumptions
- Overlooked pain points
- Unexplored opportunities
```

## Success Metrics by Phase

### Awareness
- **Traffic Quality**: Source breakdown, bounce rate
- **Brand Search**: Branded keyword volume
- **Content Engagement**: Time on page, scroll depth

### Consideration
- **Trial Signup Rate**: Landing page conversion
- **Time to Signup**: Minutes from first visit
- **Comparison Behavior**: Pricing page views, competitor research

### Onboarding
- **Activation Rate**: % completing key first action
- **Time to First Value**: Hours to first meaningful use
- **Onboarding Completion**: % finishing setup steps

### Active Use
- **DAU/WAU**: Daily and weekly active users
- **Feature Adoption**: % using core features
- **Session Metrics**: Duration, frequency, depth

### Retention/Advocacy
- **Churn Rate**: Monthly/annual retention
- **NPS Score**: Net Promoter Score
- **Referral Rate**: % of users referring others
- **Expansion Revenue**: Upgrades, upsells, add-ons

## Troubleshooting Guide

### Issue: Journey map feels generic/unrealistic
**Solution**: Provide more specific context
```
Include these details in your prompt:
- Unique value proposition
- Top 3 customer pain points (from support tickets)
- Existing user feedback quotes
- Competitive differentiators
```

### Issue: Too many opportunities identified
**Solution**: Request prioritization
```
"Rank these opportunities by:
1. Impact on [specific metric like activation rate]
2. Engineering effort required
3. Expected ROI

Show me only the top 3."
```

### Issue: Emotions don't match reality
**Solution**: Ground in real data
```
"Here are actual user quotes from interviews [paste].
Regenerate the emotional journey to match this feedback."
```

### Issue: Missing important touchpoints
**Solution**: Provide channel inventory
```
"Our product uses these channels:
- Web app, iOS app, Android app
- Email (transactional, marketing)
- In-app chat, phone support
- Slack integration, API
- LinkedIn, Twitter

Map all relevant touchpoints to journey phases."
```

### Issue: Stakeholders don't buy in
**Solution**: Focus on visual + quick wins
```
"Generate:
1. Mermaid diagram (for visual impact)
2. Just the quick wins section
3. Expected ROI for top 3 opportunities
4. One-page executive summary"
```

## Integration Workflows

### Figma
1. Generate Mermaid diagram
2. Use Figma plugin "Mermaid Chart" or "Diagrams.net"
3. Import and customize visual styling
4. Add to design system documentation

### Miro
1. Generate JSON output
2. Create Miro board template with journey structure
3. Use Miro API to import data programmatically
4. Collaborate with team on sticky notes for refinement

### Notion
1. Generate Markdown table
2. Create Notion database with journey phases as views
3. Paste table content
4. Link opportunities to product roadmap database

### Google Sheets
1. Generate Markdown table
2. Convert to CSV or TSV format
3. Import to Google Sheets
4. Add conditional formatting:
   - Green for 😊 (emotion score 4-5)
   - Yellow for 😐 (score 3)
   - Red for 😤 (score 1-2)
5. Create pivot tables for opportunity prioritization

### Jira/Linear
1. Generate opportunities list with priorities
2. Create tickets for each opportunity
3. Link to relevant epic or initiative
4. Add journey phase as label/tag
5. Track implementation progress

## File Structure
```
user-journey-map-generator/
├── index.md          # Hugo page with frontmatter and usage guide
├── SKILL.md          # Detailed skill documentation
└── INIT.md           # This file - complete initialization manifest
```

## Related Skills

- **UX Persona Generator**: Create detailed user personas before journey mapping
- **Empathy Map Builder**: Deep dive into user thoughts/feelings at specific touchpoints
- **Pain Point Analyzer**: Detailed root cause analysis of user frustrations
- **Service Blueprint Generator**: Map backend processes supporting customer journey
- **UX Metrics Dashboard**: Track KPIs at each journey phase

## License

This skill is open source and free to use. Attribution to AI Skills Directory is appreciated.

---

**Version**: 1.0
**Last Updated**: December 2025
**Maintained By**: AI Skills Directory
**Platform**: Universal (Claude, ChatGPT, Gemini, Copilot)
