# User Journey Map Generator - AI Skill

## Overview

This skill transforms AI assistants into expert UX journey mapping consultants that generate comprehensive, multi-format user journey maps showing the complete experience across touchpoints, emotions, pain points, and opportunities.

## What This Skill Does

Generates detailed user journey maps that include:

1. **Five Journey Phases**: Awareness → Consideration → Onboarding → Active Use → Retention/Advocacy
2. **Six Critical Dimensions per Phase**:
   - User actions and behaviors
   - Touchpoints (channels/interfaces)
   - User thoughts and questions
   - Emotional states (with emoji indicators)
   - Pain points and friction
   - Opportunities for improvement
3. **Three Output Formats**: Markdown tables, Mermaid diagrams, and structured JSON
4. **Actionable Insights**: Prioritized opportunities, quick wins, and validation questions

## When to Use This Skill

Perfect for:
- **UX Designers**: Creating journey maps for design documentation
- **Product Managers**: Identifying feature gaps and prioritizing roadmap
- **CX Teams**: Understanding customer experience across touchpoints
- **Service Designers**: Mapping multi-channel service experiences
- **Startup Founders**: Optimizing user acquisition and retention funnels
- **Marketing Teams**: Aligning messaging to user mindset at each phase

## Key Features

### Comprehensive Phase Coverage
Maps the entire user lifecycle from discovery to advocacy, ensuring no touchpoint is overlooked.

### Emotional Journey Tracking
Uses emoji indicators (😊 😐 😤) to visualize emotional highs and lows throughout the experience.

### Multiple Journey Types
Supports specialized journey mapping:
- Full customer journey (acquisition to advocacy)
- User onboarding (first 7 days focus)
- Support experience (problem to resolution)
- Upgrade journey (free to paid conversion)
- Retention journey (re-engagement and loyalty)

### Three Output Formats
- **Markdown Tables**: Easy to read, share in docs, embed in Notion/Confluence
- **Mermaid Diagrams**: Visual flowcharts for presentations and stakeholder alignment
- **Structured JSON**: Machine-readable format for Figma, Miro, and design tools

### Prioritized Opportunities
Ranks improvement areas by impact, separating quick wins from strategic initiatives.

### Research Validation Questions
Provides specific questions to test assumptions with real users.

## How It Works

### Step 1: Context Gathering
AI asks for:
- Product/service name and type
- Target user persona
- Journey type to focus on
- Any known pain points or opportunities

### Step 2: Journey Construction
For each of the 5 phases, AI generates:
- 3-5 specific user actions
- Relevant touchpoints (web, app, email, support, etc.)
- User thoughts and questions
- Emotional trajectory with emoji indicators
- 2-3 pain points causing friction
- 2-3 opportunities for improvement

### Step 3: Multi-Format Output
AI delivers:
1. Comprehensive markdown table with all dimensions
2. Mermaid flow diagram showing decision points
3. Structured JSON for tool integration

### Step 4: Insights and Recommendations
AI provides:
- Emotional journey chart highlighting peaks/valleys
- Top 5 prioritized opportunities with rationale
- Quick wins (low effort, high impact)
- Research questions to validate assumptions
- Next steps for UX optimization

## Example Outputs

### Markdown Table Format
```
| Phase | Actions | Touchpoints | Thoughts | Emotions | Pain Points | Opportunities |
|-------|---------|-------------|----------|----------|-------------|---------------|
| Awareness | Search for solution, Read reviews | Google, G2, Social media | "Can this solve my problem?" | 😐 | Too many options | Clear differentiation |
```

### Mermaid Diagram Format
```mermaid
journey
    title Customer Journey - Project Management SaaS
    section Awareness
      Search for solution: 3: User
      Compare options: 3: User
    section Consideration
      Sign up for trial: 4: User
      Invite team: 5: User
```

### Structured JSON Format
```json
{
  "journey": {
    "product": "Project Management SaaS",
    "user": "Remote Team Manager",
    "phases": [
      {
        "name": "Awareness",
        "actions": ["Search for solution", "Read reviews"],
        "touchpoints": ["Google", "G2"],
        "emotions": ["neutral", "curious"],
        "painPoints": ["Information overload"],
        "opportunities": ["Clear value proposition"]
      }
    ]
  }
}
```

## Best Practices

### Input Preparation
- **Be Specific**: Provide detailed product description and user persona
- **Focus Scope**: Start with one journey type, then expand
- **Share Context**: Mention known pain points or business goals
- **Define Success**: What outcome are you optimizing for?

### Output Utilization
- **Validate First**: Test assumptions with real user research
- **Prioritize Ruthlessly**: Focus on 2-3 top opportunities
- **Iterate Often**: Update maps as product evolves
- **Cross-Functional Sharing**: Use for alignment across teams

### Common Pitfalls to Avoid
- **Assumption Overload**: Don't treat generated maps as truth—validate with users
- **Analysis Paralysis**: Pick top opportunities and act, don't try to fix everything
- **One-Time Exercise**: Journey maps should be living documents
- **Missing Metrics**: Connect opportunities to measurable KPIs

## Variables Reference

| Variable | Purpose | Example Values |
|----------|---------|----------------|
| `PRODUCT_NAME` | Product/service to map | "Slack", "Airbnb", "Shopify" |
| `PRODUCT_TYPE` | Category/industry | "SaaS", "E-commerce", "Mobile app" |
| `TARGET_USER` | Primary persona | "Remote team manager", "First-time buyer" |
| `JOURNEY_TYPE` | Focus area | "onboarding", "support", "full journey" |

## Integration Examples

### Figma Workflow
1. Generate journey map with this skill
2. Copy Mermaid diagram code
3. Use Figma plugin "Mermaid Chart" to visualize
4. Customize colors and styling in Figma

### Miro Workflow
1. Generate JSON output
2. Create custom Miro board template
3. Use Miro API to import structured data
4. Collaborate with team on improvements

### Notion Workflow
1. Generate markdown table format
2. Create Notion database for journey phases
3. Paste table content into database
4. Link opportunities to product roadmap

### Google Sheets Workflow
1. Generate markdown table
2. Convert to CSV format
3. Import to Google Sheets
4. Add conditional formatting for emotions
5. Track improvement implementation progress

## Advanced Usage

### Comparative Journey Mapping
Map journeys for multiple user personas side-by-side to identify where experiences diverge.

**Prompt**: "Generate journey maps for both 'individual contributor' and 'team manager' personas using our project management tool. Highlight where their experiences differ."

### Before/After Journey Maps
Create current state vs. desired state maps to visualize improvement impact.

**Prompt**: "Create two journey maps: current onboarding experience vs. optimized onboarding after implementing quick wins. Show emotion improvements."

### Multi-Channel Service Journeys
Map complex experiences spanning digital and physical touchpoints.

**Prompt**: "Generate a support journey for our banking app including web, mobile app, phone support, and branch visit touchpoints."

### Journey Map Auditing
Have AI review existing journey maps for gaps or inconsistencies.

**Prompt**: "Here's our current journey map [paste]. Audit it for missing touchpoints, unrealistic emotions, or overlooked opportunities."

## Measuring Success

Track these metrics to validate journey map improvements:

**Awareness Phase**:
- Traffic sources and quality
- Brand search volume
- Content engagement rates

**Consideration Phase**:
- Trial signup rate
- Time to signup
- Comparison page views

**Onboarding Phase**:
- Activation rate (completing key action)
- Time to first value
- Onboarding completion rate

**Active Use Phase**:
- Daily/Weekly active users
- Feature adoption rates
- Session duration and frequency

**Retention/Advocacy Phase**:
- Churn rate
- NPS score
- Referral rate
- Expansion revenue

## Troubleshooting

**Problem**: Journey map feels generic or unrealistic
**Solution**: Provide more specific context about your product, user pain points, and unique value proposition

**Problem**: Too many opportunities identified
**Solution**: Ask AI to "rank the top 3 opportunities by potential impact on [specific metric]"

**Problem**: Emotions don't match reality
**Solution**: Share actual user feedback or support tickets to ground the map in real data

**Problem**: Missing important touchpoints
**Solution**: List all channels your product uses, then ask AI to map them to appropriate phases

**Problem**: Difficult to get stakeholder buy-in
**Solution**: Use Mermaid diagram format for visual appeal and focus on quick wins with clear ROI

## Version History

**v1.0** (December 2025)
- Initial release with 5-phase framework
- Three output formats (Markdown, Mermaid, JSON)
- Support for 5 journey types
- Prioritized opportunities and quick wins
- Research validation questions

## Related Skills

- **UX Persona Generator**: Create detailed personas to inform journey mapping
- **Empathy Map Builder**: Deep dive into user thoughts/feelings at each touchpoint
- **Pain Point Analyzer**: Detailed analysis of specific user frustrations
- **Service Blueprint Generator**: Backend processes supporting customer journey
- **UX Metrics Dashboard**: Track KPIs at each journey phase

## License & Attribution

This skill is open source and free to use. When sharing or adapting, please attribute to the AI Skills Directory.

## Support & Feedback

Found a bug or have a suggestion? Visit the [AI Skills Directory](https://aiskillsdirectory.com) to submit feedback or request enhancements.
