---
name: visual-balance-ui-designer
version: 1.0.0
description: Design interfaces with clarity, usability, and visual balance using Gestalt principles, visual hierarchy, whitespace strategy, and intentional composition.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

The Visual Balance UI Designer skill helps you create interfaces that feel natural, guide attention effortlessly, and reduce cognitive load through foundational design principles. This is a **prompt-only skill** with no scripts to generate.

**Time to initialize:** ~1 minute

## Directory Structure

```
visual-balance-ui-designer/
├── SKILL.md    # Main skill instructions and design principles
└── INIT.md     # This initialization file
```

## Dependencies

None required. This is a prompt-only skill.

## Files to Generate

None. Simply use SKILL.md content directly with your AI assistant.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r visual-balance-ui-designer/ ~/.claude/skills/visual-balance-ui-designer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- GitHub Copilot

## Variables

Customize these placeholders when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{design_context}}` | `landing page` | Type of interface (landing page, app screen, dashboard, form) |
| `{{primary_goal}}` | `sign up` | Main user action or conversion goal |
| `{{brand_personality}}` | `professional and approachable` | Brand voice and visual tone |
| `{{color_scheme}}` | `blue-based trust palette` | Primary color palette approach |
| `{{target_audience}}` | `general consumers` | Who will use this interface |

## Quick Start

Once installed, you can immediately ask the skill to:

1. **Review a design** - Share a screenshot or Figma link
2. **Fix a specific problem** - Describe what feels "off"
3. **Learn a principle** - Ask about Gestalt, hierarchy, or balance
4. **Start fresh** - Describe what you're building

### Example Prompts

```
"Review my SaaS landing page for visual balance issues. The hero
section feels cluttered with too many elements competing for attention."
```

```
"Explain how to use the Gestalt principle of proximity to improve
my form design."
```

```
"Help me create visual hierarchy for a dashboard with 6 different
data widgets that all feel equally important right now."
```

## Core Principles Covered

This skill teaches and applies:

1. **Gestalt Laws** - Proximity, Similarity, Figure-Ground, Continuity, Closure, Common Region
2. **Visual Hierarchy** - Size, weight, color, position, whitespace
3. **Visual Balance** - Symmetrical vs asymmetrical, visual weight factors
4. **Whitespace Strategy** - Macro/micro whitespace, the squint test
5. **Typography Hierarchy** - Font pairing, type scale, contrast through type
6. **Color Harmony** - Monochromatic, analogous, complementary, 60-30-10 rule
7. **Scanning Patterns** - F-pattern, Z-pattern, Gutenberg diagram
8. **Grid Systems** - 12-column grids, breaking the grid intentionally

## Related Skills

For complete design workflow, consider pairing with:

- **Frontend Design Pro** - For implementation with React, tokens, and WCAG
- **Landing Page Conversion Designer** - For CRO psychology and A/B testing
- **Design System Architect** - For comprehensive token and component systems
- **Accessible Color Palette Generator** - For WCAG-compliant color systems

---
Downloaded from [Find Skill.ai](https://findskill.ai)
