---
name: difficult-conversation-prep
version: 1.0.0
---

# Initialization

Prepare for any difficult conversation with a comprehensive framework combining Crucial Conversations STATE method, Marshall Rosenberg's Nonviolent Communication (NVC), and the O'DEAR framework. This skill helps you analyze your situation, prepare emotionally, draft word-for-word scripts, plan for multiple scenarios, and create a post-conversation follow-up plan -- for workplace, personal, and family situations.

## Structure

- `SKILL.md` - Main skill prompt with complete conversation preparation framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r difficult-conversation-prep/ ~/.claude/skills/difficult-conversation-prep/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Start a new conversation describing the conversation you need to prepare for

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `my_situation` | `` | My specific situation or conversation I need to prepare for |
| `my_relationship` | `` | My relationship to the other person (boss, partner, friend, family) |
| `my_goal` | `` | What I want to achieve from this conversation |
| `my_concerns` | `` | My biggest fears or concerns about having this conversation |

## Example Usage

**Scenario**: You need to tell your boss you are resigning, but you are mid-project and worried about their reaction.

**Prompt**:
```
I need to tell my boss I'm leaving in 2 weeks but I'm worried about their
reaction since we're mid-project. They've been a good manager overall and
I don't want to burn the bridge. Help me prepare the conversation so it
goes as smoothly as possible.
```

**What you'll receive**:
- Situation analysis separating facts from assumptions
- Emotional preparation exercises and regulation strategies
- Word-for-word opening script using your choice of NVC, STATE, or O'DEAR frameworks
- Three-scenario plan (best, most likely, worst case)
- Pushback response library customized to your boss's likely objections
- De-escalation phrases for if things get heated
- Logistics guidance on timing and setting
- Post-conversation follow-up plan

## Frameworks Included

| Framework | Source | Use |
|-----------|--------|-----|
| STATE Method | Crucial Conversations (Patterson et al.) | Share facts, Tell story, Ask, Talk tentatively, Encourage testing |
| NVC / OFNR | Marshall Rosenberg | Observation, Feelings, Needs, Requests |
| O'DEAR | UBC Faculty of Medicine | Open, Describe, Explain, Ask, Request |
| CPR | Crucial Conversations | Content, Pattern, Relationship issue identification |
| Fact vs. Story | Crucial Conversations | Separating observable events from assumptions |

## Conversation Types Covered

- Asking for a raise or promotion
- Giving notice or resigning
- Addressing poor performance (as manager)
- Reporting harassment or discrimination
- Setting boundaries with family
- Discussing relationship problems with a partner
- Talking to a friend about their behavior
- End-of-life and health decisions
- Any conversation you have been putting off
