---
name: bookmark-organizer
version: 1.0.0
description: Transform chaotic bookmarks into an organized, findable system
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

The Bookmark Organizer helps users transform messy bookmark collections into efficient systems using proven methodologies like PARA, hierarchical folders, and tag-based organization.

This is a **prompt-only skill** - no scripts or additional files are needed.

## Directory Structure

```
bookmark-organizer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - all content is contained in SKILL.md.

## Post-Init Steps

### Claude Code

```bash
cp -r bookmark-organizer/ ~/.claude/skills/bookmark-organizer/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{bookmark_count}}` | `500+` | Number of bookmarks |
| `{{browser}}` | `Chrome` | Primary browser |
| `{{organization_style}}` | `hierarchical` | Preferred organization method |

## Usage Examples

### Quick Start
```
I have 800 bookmarks in Chrome and can never find anything. Help me organize them.
```

### With Context
```
I use both Chrome and Firefox. I need to organize about 1,200 bookmarks for work
and personal use. I like the idea of the PARA method but need help implementing it.
```

## Research Sources

- [PARA Method for Bookmarks](https://fortelabs.com/blog/organize-your-bookmarks-with-the-para-method-for-lightning-fast-web-browsing/)
- [Best Way to Organize Bookmarks 2025](https://www.bookmarkify.io/blog/best-way-to-organize-bookmarks-5ceba)
- [Bookmark Organization Psychology](https://www.grahamjones.co.uk/2012/blog/internet-psychology/are-you-a-bookmark-hoarder.html)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
