---
name: cloud-storage-cleanup-planner
version: 1.0.0
description: Free up cloud storage by finding large files, removing duplicates, and establishing maintenance habits
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

The Cloud Storage Cleanup Planner helps users reclaim space across Google Drive, iCloud, Dropbox, and OneDrive through systematic cleanup and maintenance habits.

This is a **prompt-only skill** - no scripts needed.

## Directory Structure

```
cloud-storage-cleanup-planner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Post-Init Steps

### Claude Code

```bash
cp -r cloud-storage-cleanup-planner/ ~/.claude/skills/cloud-storage-cleanup-planner/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{primary_cloud}}` | `Google Drive` | Primary cloud service |
| `{{storage_used}}` | `90%+` | Current usage percentage |

## Usage Examples

### Quick Start
```
My Google Drive is full. Help me free up space without losing important files.
```

### Multi-Platform
```
I'm getting storage warnings from both iCloud and Google. I think I have the same
photos backed up to both. Help me consolidate and free up space.
```

## Research Sources

- [Google Storage Management](https://support.google.com/drive/answer/6374270)
- [iCloud Storage Full Solutions](https://www.cloudwards.net/solved-icloud-storage-full/)
- [Filerev for Google Drive](https://filerev.com/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
