---
name: concept-connector
version: 1.0.0
description: Find hidden connections between any two ideas, subjects, or fields
author: FindSkill.ai
license: MIT
---

# Concept Connector — Initialization

## Overview

This is a prompt-only skill for discovering hidden relationships between any two concepts. It uses a 5-dimension framework to find structural, process, cause-effect, system, and human parallels.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with connection framework and patterns library
- `INIT.md` — This initialization guide

## Directory Structure

```
concept-connector/
├── SKILL.md    # Main skill with framework and examples
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude any two concepts you want to connect

### ChatGPT / Gemini / Copilot
Same process — paste and give any two topics.

## Core Capabilities

1. **5-Dimension Connection Framework** — Structural, process, cause-effect, system, human
2. **Visual Connection Maps** — Side-by-side parallel layouts
3. **Universal Patterns Library** — Feedback loops, networks, growth/decay, waves, equilibrium
4. **Three Depth Levels** — Quick (30 sec), standard (2-3 min), deep (5+ min)
5. **"So What?" Bridge** — Explains why the connection helps learning/thinking
6. **Creative Applications** — Study techniques, essay writing, brainstorming, teaching
7. **6-Degrees Game** — Connect any two topics in 6 steps or fewer

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `concept_a` | `` | First idea or subject to connect |
| `concept_b` | `` | Second idea or subject to connect |
| `purpose` | `deeper understanding` | Why you want to connect these |

## Usage Examples

### Example 1: Study Aid

**User:** "Connect Roman Empire and cellular biology for my exams."

**AI Response:** Creates a connection map showing structural parallels (emperor=nucleus, roads=ER), process parallels (expansion=mitosis), and a memory hook for exam recall.

### Example 2: Creative Brainstorming

**User:** "How can I use music concepts to solve a business problem?"

**AI Response:** Maps harmony to team collaboration, rhythm to project cadence, improvisation to agile methodology, and composition to strategic planning.

### Example 3: Teaching

**User:** "I need to teach electricity to 8th graders using something they already understand."

**AI Response:** Builds a water flow analogy: voltage=pressure, current=flow rate, resistance=pipe narrowing, battery=pump.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Topics seem impossible to connect | Try the 6-Degrees game — everything connects in 6 steps |
| Connection feels forced | Focus on the strongest 1-2 dimensions, not all 5 |
| Too abstract | Ask for concrete examples from everyday life |
| Need it for a specific class | Tell the AI which subjects you're studying |
| Want deeper analysis | Request "deep exploration" level |

## Best Practices

1. **Start with curiosity** — the more unlikely the pair, the more interesting the connections
2. **Use connections for memory** — cross-domain hooks create stronger recall
3. **Look for universal patterns** — feedback loops, networks, and growth curves appear everywhere
4. **Make your own connections** — once you see the framework, find parallels yourself
5. **Apply to real problems** — use cross-domain thinking for creative solutions
6. **Share connections** — explaining them to others deepens your understanding

---
Downloaded from [Find Skill.ai](https://findskill.ai)
