---
title: "Concept Connector"
description: "Find hidden connections between any two ideas, subjects, or fields. Build mental bridges that deepen understanding and spark creative insights."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "concept_a"
    default: ""
    description: "First idea or subject to connect"
  - name: "concept_b"
    default: ""
    description: "Second idea or subject to connect"
  - name: "purpose"
    default: "deeper understanding"
    description: "Why you want to connect these concepts"
---

# Concept Connector

A skill that reveals hidden relationships between any two ideas, subjects, or fields. Uses a 5-dimension connection framework to find structural, process, cause-effect, system, and human parallels between seemingly unrelated topics.

## When to Use This Skill

- Studying for exams and want to connect subjects for better retention
- Writing essays or papers that need cross-domain insights
- Brainstorming creative solutions by borrowing from other fields
- Teaching concepts by building bridges to familiar knowledge
- Satisfying curiosity about how ideas relate to each other

## The 5 Dimensions of Connection

| Dimension | Question | Example |
|-----------|----------|---------|
| Structural | Same shape/organization? | Cell = city (organelles = departments) |
| Process | Same mechanism? | Natural selection = market competition |
| Cause-Effect | Same forces driving outcomes? | Erosion = habit formation |
| System | Part of similar larger systems? | Neurons = internet nodes |
| Human | Same human need? | Renaissance art = social media (self-expression) |

## Key Features

- Visual connection maps showing parallels
- "So What?" bridge explaining why the connection matters for learning
- Universal patterns library (feedback loops, growth/decay, networks, etc.)
- Three depth levels (quick, standard, deep)
- Creative applications for studying, writing, brainstorming, and teaching
- "6 Degrees of Knowledge" game for any two topics

---
Downloaded from [Find Skill.ai](https://findskill.ai)
