---
name: course-completion-plan
version: 1.0.0
---

# Course Completion Plan - Initialization

Transform overwhelming online courses into achievable 20-minute daily chunks with intelligent scheduling, spaced repetition, and adaptive pacing. Beat the 90% course abandonment rate.

## Structure

```
course-completion-plan/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r course-completion-plan/ ~/.claude/skills/course-completion-plan/

# Or add via Claude Code
claude mcp add-skill course-completion-plan
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT's system instructions or Custom GPT instructions
4. Optional: Add "Course Completion Plan" as conversation starter

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the main skill content
3. Paste at the start of your conversation or into system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{course_duration_hours}}` | `10` | Total course duration in hours |
| `{{daily_learning_time}}` | `20` | Target daily session length in minutes |
| `{{learning_pace}}` | `1.0` | Individual pace multiplier (0.7-1.5) |
| `{{spaced_repetition_intervals}}` | `1, 7, 21, 45` | Days between review sessions |
| `{{retention_threshold}}` | `75` | Target mastery level % |
| `{{time_buffer_percent}}` | `25` | Extra time buffer % |

## Quick Start

Once installed, start with:

```
"I just enrolled in a 10-hour Python course on Udemy with 40 lectures.
Create a personalized 20-minute daily schedule that I can complete in
8 weeks, starting next Monday. I'm a beginner with no coding experience."
```

The AI will:
1. Analyze the course structure
2. Break it into daily 15-25 minute chunks
3. Generate a complete schedule with dates
4. Add spaced repetition review sessions
5. Provide progress tracking and adaptation

## Key Features

- **Intelligent Chunking**: Breaks courses into cognitive-load-optimized segments
- **Spaced Repetition**: SM-2 algorithm schedules reviews at 1, 7, 21, 45 days
- **Adaptive Pacing**: Adjusts schedule based on actual completion speed
- **Multi-Course Paths**: Sequences courses with prerequisite awareness
- **Intervention System**: Detects when you're falling behind and offers recovery options

## Example Prompts

**Basic Schedule**:
"Create a learning schedule for [course name], [X hours], [Y lectures]. I can study 20 min/day weekdays, 45 min weekends."

**Progress Check**:
"I completed Day 5. How am I doing? What's next?"

**Catch Up**:
"I'm 3 days behind. Help me get back on track."

**Multi-Course Path**:
"I want to learn data science. Help me sequence: Python (10h), SQL (8h), Statistics (10h), ML Basics (12h)."

## Research Foundation

This skill is based on peer-reviewed research:
- SM-2 spaced repetition algorithm (SuperMemo)
- Lindsey et al. (2019) recall probability optimization
- Cognitive load theory and microlearning effectiveness
- Ultradian rhythm research (90-minute attention cycles)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
