---
name: deadline-extension-requester
version: 1.0.0
---

# Deadline Extension Requester - Initialization

Craft professional emails to request deadline extensions from professors. This skill provides templates, timing advice, and strategies that increase approval odds for extension requests.

## Structure

```
deadline-extension-requester/
├── SKILL.md      # Main skill prompt (full extension request coach)
└── INIT.md       # This file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code (Recommended)

```bash
cp -r deadline-extension-requester/ ~/.claude/skills/deadline-extension-requester/
```

Then reference with: `Read the skill at ~/.claude/skills/deadline-extension-requester/SKILL.md`

### ChatGPT / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or chat

### Quick Start

After installation, try:

```
I need help asking my professor for an extension on my research paper. It's due Friday but I've been sick. Can you help me write the email?
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{course_code}}` | `PSYCH 211-01` | Course number and section |
| `{{assignment_name}}` | `Research Paper` | Name of the assignment |
| `{{original_deadline}}` | `Friday, December 20th` | Current due date |
| `{{extension_request}}` | `3 days` | How much additional time needed |
| `{{reason}}` | `illness` | The situation requiring extension |

## What This Skill Does

1. **Analyzes syllabus policies** - Checks if extension is even needed
2. **Assesses legitimacy** - Evaluates if reason is likely to be accepted
3. **Optimizes timing** - Advises on when to send the request
4. **Drafts professional emails** - Creates concise, effective requests
5. **Provides templates** - Ready-to-use emails for common scenarios
6. **Guides documentation** - Explains what evidence to attach
7. **Plans for denials** - Offers backup strategies if rejected

## Key Features

- **Email templates** for illness, family emergency, mental health, tech failure, and disability accommodations
- **Timing hierarchy** showing approval odds based on when you ask
- **Red flag detector** identifying phrases that hurt your chances
- **Documentation guidance** for what to attach and how
- **Denial response templates** for graceful acceptance

## Example Scenarios

**Medical Issue:**
"I have the flu and need 3 more days for my essay"

**Family Emergency:**
"There's a family emergency and I can't complete the project on time"

**Technology Failure:**
"My computer crashed and I lost my assignment"

**Disability Accommodation:**
"I need to use my accommodation letter for an extension"

**Past Deadline:**
"The deadline already passed - what can I do now?"

## Success Factors

The skill emphasizes:

1. **Check syllabus first** - You may already have flex days
2. **Request early** - 24-48+ hours before deadline minimum
3. **Be specific** - Exact dates and duration
4. **Keep it brief** - 3-5 sentences maximum
5. **Stay professional** - Formal but genuine tone
6. **Provide documentation** - When available
7. **Accept gracefully** - It's a request, not a demand

---
Downloaded from [Find Skill.ai](https://findskill.ai)
