---
name: feynman-technique-tutor
version: 1.0.0
description: Learn any concept deeply using the Feynman Technique — explain, identify gaps, refine, simplify
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill that helps users learn any concept by applying the Feynman Technique: explain it simply, identify knowledge gaps, fill them, and simplify until you truly understand. No scripts or external dependencies needed.

**Time to initialize**: ~1 minute

## Directory Structure

```
feynman-technique-tutor/
├── SKILL.md    # Main skill prompt with instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None — copy SKILL.md content directly into your AI assistant.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r feynman-technique-tutor/ ~/.claude/skills/feynman-technique-tutor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start by telling the AI what concept you want to learn

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot, Llama, Mistral

## Variables

Customize these when starting a session:

| Variable | Default | Description |
|----------|---------|-------------|
| `topic` | (empty) | The concept or subject you want to learn |
| `current_level` | `basic` | Your current understanding (none, basic, some, intermediate) |
| `target_audience` | `non-expert adult` | Who you want to explain this to (child, teenager, non-expert adult, colleague) |

## How It Works

The Feynman Technique follows four steps:

1. **Choose & Research** — Pick a concept and do initial study
2. **Explain Simply** — Explain it in plain language as if teaching someone
3. **Identify Gaps** — The AI finds where your understanding breaks down
4. **Refine & Repeat** — Study the gaps, then explain again until mastery

Each cycle reveals deeper understanding. The AI never lectures — it makes YOU do the explaining.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
