---
name: jargon-buster
version: 1.0.0
---

# Initialization

Jargon Buster transforms complex academic papers into simple, engaging explanations that a 12-year-old can understand. Using the Feynman Technique, Flesch-Kincaid readability targeting, and creative analogies, this skill helps students, curious learners, journalists, and non-specialists access scientific discoveries without needing a PhD.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for simplifying academic papers

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r jargon-buster/ ~/.claude/skills/jargon-buster/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_grade_level}}` | `6` | Reading level target using Flesch-Kincaid scale (3-8). Lower = simpler. |
| `{{explanation_depth}}` | `medium` | How much detail: brief, medium, or detailed |
| `{{analogy_density}}` | `0.6` | How many analogies to use (0.0-1.0 scale) |
| `{{tone}}` | `curious` | Explanation style: curious, story, practical, or playful |
| `{{focus_area}}` | `all` | Sections to prioritize: all, abstract, results, or significance |

## Usage Examples

### Basic Usage
Share an academic paper and ask:
```
"Can you explain this paper in simple terms?"
```

### Specify Focus
```
"I just need to understand the Results section of this paper."
```

### Create Glossary
```
"What do all these technical terms mean? Can you make a glossary?"
```

### Why It Matters
```
"Why should I care about this research? What's the real-world impact?"
```

### Adjust Level
```
"Can you explain this at an even simpler level, like for a 4th grader?"
```

## Key Features

1. **Full Paper Translation**: Converts entire papers to kid-friendly summaries
2. **Section-by-Section Deep Dive**: Focus on specific sections (Abstract, Methods, Results, etc.)
3. **Glossary Generator**: Creates custom dictionaries with simple definitions and analogies
4. **Impact Translation**: Explains why research matters in everyday life
5. **Interactive Q&A**: Answers follow-up questions at appropriate reading level
6. **Reading Level Adjuster**: Customizes complexity for different audiences

## Core Techniques Used

- **Feynman Technique**: Explain concepts as if teaching a child
- **Flesch-Kincaid Targeting**: Grade 4-6 readability level
- **IMRaD Awareness**: Section-specific simplification strategies
- **Analogy Generation**: Relatable comparisons for abstract concepts
- **Plain Language Standards**: NHS, AGU, Science Societies guidelines

---
Downloaded from [Find Skill.ai](https://findskill.ai)
