---
name: learning-style-adapter
version: 1.0.0
---

# Learning Style Adapter - Initialization

Transform any concept into your preferred learning format. This skill converts abstract explanations into hands-on exercises, visual guides, real-world projects, and interactive discovery - because reading isn't the only path to understanding.

## What This Skill Does

- Converts theoretical concepts into practical, hands-on exercises
- Delivers the same concept through multiple modalities (analogy, visual, process, example, Socratic)
- Adapts difficulty based on demonstrated understanding
- Uses Socratic questioning to guide discovery
- Creates project-based learning paths with embedded lessons
- Provides specific, actionable feedback (not generic praise)

## Structure

```
learning-style-adapter/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r learning-style-adapter/ ~/.claude/skills/learning-style-adapter/
```

Then reference in your Claude configuration or invoke directly.

### For ChatGPT / Claude / Gemini / Copilot Users

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Start by describing what you want to learn

## Quick Start

After installation, try:

```
"I need to understand [concept] but I hate reading long explanations.
Can you teach me through hands-on exercises instead?"
```

Or:

```
"Explain [topic] for someone who learns by doing, not reading."
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `learning_context` | `general` | Domain or field (software_development, biology, business, etc.) |
| `engagement_level` | `moderate` | Gamification intensity: minimal, moderate, high |
| `modality_preference` | `mixed` | Initial approach: hands-on-first, visual-first, discussion-first, example-first, mixed |
| `pacing_control` | `adaptive` | Who controls speed: learner-controlled, adaptive, structured |
| `feedback_style` | `constructive` | Feedback detail: minimal, constructive, comprehensive |
| `challenge_level` | `auto-adjust` | Difficulty scaling: easy, moderate, challenging, auto-adjust |

## Example Prompts

**Hands-on request:**
```
"I need to understand recursion in programming, but I hate reading explanations.
I've tried tutorials and they all start with theory I don't care about.
Can you teach me through a hands-on exercise instead?"
```

**Multi-modal explanation:**
```
"Explain photosynthesis for someone who learns by doing, not reading."
```

**Project-based learning:**
```
"I want to learn data visualization but want to build something real while learning."
```

**Skill mastery:**
```
"Help me master SQL queries. I'm a beginner but learn fast when I can practice."
```

## Key Frameworks Used

- **Kolb's Experiential Learning Cycle**: Concrete Experience → Reflection → Conceptualization → Experimentation
- **Bloom's Taxonomy**: Push toward higher cognitive levels (Analyze, Evaluate, Create)
- **Universal Design for Learning (UDL)**: Multiple means of representation, expression, and engagement
- **Zone of Proximal Development**: Challenge sweet spot between too easy and too hard
- **Spaced Repetition**: Optimal review intervals for retention

## Related Skills

- **Learning Style Detector** - Identify your preferences first
- **Adaptive Learning Companion** - AI tutor that adapts when stuck
- **Learning Path Designer** - Design complete learning sequences
- **AI Tutor** - General-purpose tutoring

## Notes

This skill explicitly acknowledges that "learning styles" (visual/auditory/kinesthetic as fixed types) have been debunked by research. Instead, it focuses on **learning preferences** - ways people enjoy engaging with content - while ensuring all learners benefit from multi-modal instruction and hands-on practice.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
