---
name: why-answer-generator
version: 1.0.0
---

# Initialization

Transform complex questions into clear, layered explanations using the Feynman Technique and ELI5 methodology. Creates simple, intermediate, and advanced explanations with relatable analogies and misconception correction.

## Structure

- `SKILL.md` - Main skill prompt with complete explanation generation framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r why-answer-generator/ ~/.claude/skills/why-answer-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything below the second `---`)
3. Paste into AI assistant as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `target_audience_age` | `13` | Sets vocabulary complexity (5-7, 8-12, 13-17, 18+, Expert) |
| `explanation_depth` | `three_tier` | Output structure: simple, three_tier, or extended |
| `include_misconceptions` | `true` | Include misconception correction sections |
| `metaphor_style` | `everyday` | Analogy type: everyday, visual, mechanical, narrative |
| `technical_terminology` | `progressive` | Jargon handling: avoid, progressive, included |
| `interactive_elements` | `true` | Include follow-up questions and suggestions |

## Quick Start

After installation, ask any "Why?" question:

- "Why is the sky blue?"
- "Why do we dream?"
- "Why does ice float?"
- "Why is inflation happening?"

Specify audience for tailored explanations:

- "Explain gravity to a 6-year-old"
- "Why does quantum entanglement work? I'm a physics major."
- "Explain compound interest - I'm teaching teenagers about money"

## Features

- **Three-tier explanations**: Simple (ELI5), Intermediate (with analogy), Advanced (technical)
- **Misconception detection**: Identifies and corrects common false beliefs
- **Audience adaptation**: Adjusts vocabulary and analogies based on specified audience
- **Vocabulary scaffolding**: Introduces technical terms progressively
- **Follow-up suggestions**: Provides natural next questions to explore

## Example Output

**User**: "Why do we yawn?"

**Simple Answer**: Your brain triggers a yawn to bring in extra oxygen and cool down when it's getting sluggish.

**Intermediate Explanation**: Think of your brain like a computer that occasionally needs to cool its processors. When you're tired, bored, or transitioning between activities, your brain temperature rises slightly and oxygen levels drop. A yawn is like opening all the vents at once - the big breath brings in cool air and extra oxygen, while stretching your jaw increases blood flow to your head.

**Advanced Explanation**: Yawning appears to serve thermoregulatory functions for the brain. Research by Andrew Gallup suggests that the deep inhalation and jaw stretch during yawning promotes blood flow and helps dissipate excess heat from the brain. The contagious nature of yawning may have evolved as a social synchronization mechanism, keeping group alertness coordinated.

**Common Misconception**: "Yawning is just about being tired or bored" - While associated with these states, yawning can occur during any transition state and serves physiological functions beyond simple fatigue signaling.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
