---
name: email-tone-adjuster
version: 1.0.0
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
---

# Email Tone Adjuster - Initialization

Transform any email's tone instantly -- angry to professional, passive to assertive, casual to formal. This skill analyzes your email drafts, detects problematic language and tone risks, then rewrites them in your target tone with explanations of every change. Covers 10 distinct tones, 13 red-flag phrases, 8 workplace scenarios, and cultural adaptation guidelines.

## Package Contents

```
email-tone-adjuster/
├── SKILL.md    # Main skill prompt (paste into AI assistant)
└── INIT.md     # This initialization file
```

## Quick Start

### Claude Code / Claude Projects

```bash
# Copy to Claude Code skills directory
cp -r email-tone-adjuster/ ~/.claude/skills/email-tone-adjuster/
```

Then reference in your conversations or add to project instructions.

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into:
   - **ChatGPT:** Custom Instructions or GPT Builder
   - **Gemini:** Gems configuration
   - **Copilot:** Custom agent or conversation starter

### Direct Use

Simply paste the SKILL.md content at the start of any conversation and begin sharing email drafts to adjust.

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Tone Spectrum Analysis | Identifies current tone from 10 defined categories (angry, blunt, passive-aggressive, assertive, professional, neutral, diplomatic, friendly, formal, casual) |
| Red-Flag Detection | Catches 13 passive-aggressive and problematic phrases with professional alternatives |
| Complete Rewrites | Adjusts subject line, greeting, body, and closing to match target tone |
| Scenario Templates | Pre-built transformations for 8 common workplace situations |
| Cultural Awareness | Adapts tone for high-context vs. low-context and hierarchical vs. egalitarian cultures |
| Hierarchy Adjustment | Calibrates formality based on recipient's position relative to sender |
| Emergency Recovery | Helps craft follow-up messages after sending a problematic email |
| Batch Analysis | Reviews entire email threads and identifies where tone went off track |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_email}}` | (empty) | Email draft that needs tone adjustment |
| `{{my_target_tone}}` | `professional` | Desired tone: professional, friendly, assertive, diplomatic, urgent, formal, casual, warm, direct |
| `{{my_context}}` | (empty) | Context about recipient, situation, and desired outcome |

## Supported Tone Transformations

| From | To | Key Technique |
|------|----|---------------|
| Angry | Professional | Remove emotional intensifiers, convert accusations to observations |
| Passive | Assertive | Remove hedging, add clear ownership with "I" statements |
| Passive-Aggressive | Direct | Remove sarcasm, state the real concern explicitly |
| Blunt | Diplomatic | Add acknowledgment, frame feedback as questions |
| Casual | Formal | Remove contractions, use professional vocabulary |
| Formal | Friendly | Add contractions, personal touches, warm greetings |
| Diplomatic | Assertive | Remove excessive hedging, state positions clearly |
| Harsh | Warm | Add empathy, frame criticism as coaching |

## Usage Examples

### Basic Tone Adjustment

```
User: Rewrite this email to be more professional:

"Hey, I noticed you presented MY slides in the meeting without even mentioning
me. This is the third time and I'm really angry."

AI: [Provides tone analysis, rewritten email, and explanation of changes]
```

### With Context

```
User: Make this more diplomatic. It's going to a client who missed their deadline:

"Your deliverables are late again. This is impacting our entire project timeline.
When will you actually deliver what you promised?"

AI: [Provides client-appropriate diplomatic rewrite with relationship preservation]
```

### Emergency Recovery

```
User: I already sent this angry email to my boss. How do I fix it?

"Nobody is taking this seriously and it's going to blow up."

AI: [Provides follow-up email options: clarification, call redirect, or acknowledgment]
```

## Red-Flag Phrase Quick Reference

These phrases should always be replaced:

| Phrase | Replace With |
|--------|-------------|
| "Per my last email..." | "To build on my earlier note..." |
| "As I already mentioned..." | "To reiterate an important point..." |
| "Just a friendly reminder..." | "Quick heads-up -- [deadline] is [date]." |
| "Thanks in advance" | "I'd really appreciate your help with this." |
| "Any updates on this?" | "Could you share a status update by [date]?" |
| "Not sure if you saw my message..." | "Following up on [topic]..." |
| "Correct me if I'm wrong, but..." | "My understanding is [X]. Does that match yours?" |

## Scenario Coverage

| Scenario | Transformation |
|----------|---------------|
| Coworker took credit for your work | Angry --> Assertive |
| Declining a request | Blunt --> Diplomatic |
| Following up after being ignored | Passive-Aggressive --> Professional |
| Giving negative feedback | Harsh --> Warm + Direct |
| Escalating to leadership | Emotional --> Executive-ready |
| Apologizing for a mistake | Defensive --> Professional |
| Asking for a raise | Tentative --> Confident |
| Addressing a missed deadline | Avoidant --> Professional |

## Integration Tips

### Daily Workflow

1. **Pre-send check:** Before sending any important email, paste the draft for a tone review
2. **Template building:** Use scenario templates as starting points for recurring situations
3. **Pattern recognition:** Notice which red-flag phrases appear in your drafts repeatedly
4. **Cultural prep:** Before emailing someone from a different cultural background, check the cultural guidelines

### Combine With

- **Active Listening Master** - Understand context before responding to emails
- **Conflict Resolution Expert** - Handle the underlying conflict an email thread reveals
- **Assertive Communication Coach** - Build confidence in expressing needs across all formats
- **Corporate Speak Decoder** - Decode the tone of emails you receive
- **Slack Tone Polisher** - Apply the same tone awareness to instant messages

## Troubleshooting

**Rewrites sound too corporate/stiff:**
- Specify "keep my voice, just fix the tone"
- Use target tone "friendly" or "casual" instead of "professional"
- Add context: "This person and I are close colleagues"

**Rewrites lose the urgency:**
- Use target tone "assertive" or "urgent" instead of "diplomatic"
- Specify: "The urgency is real -- keep it but make it professional"

**Not sure which tone to use:**
- Describe the situation and ask: "What tone would you recommend here?"
- The skill includes a decision matrix mapping situations to recommended tones

**Email is already fine:**
- The skill will tell you when an email is ready to send as-is, with optional minor polish suggestions

## Best Practices

1. **Share context** - The more the AI knows about the recipient and situation, the better the rewrite
2. **Be honest** - Paste what you actually want to say, not the sanitized version
3. **Specify the relationship** - Manager vs. peer vs. client changes the appropriate tone significantly
4. **State your goal** - "I want action" produces a different rewrite than "I want to preserve the relationship"
5. **Review before sending** - AI suggestions are starting points; adjust to match your authentic voice

---

Downloaded from [Find Skill.ai](https://findskill.ai)
