---
name: aging-parent-care-coordinator
version: 1.0.0
---

# Aging Parent Care Coordinator - Initialization

A comprehensive eldercare planning assistant that helps adult children coordinate health, legal, financial, and living arrangements for aging parents while managing family dynamics and preventing caregiver burnout.

## What This Skill Does

This skill transforms the AI into an eldercare coordination expert that can:

- **Assess Care Needs**: Evaluate parent's functional capacity using ADL/IADL frameworks
- **Organize Legal Documents**: Guide through power of attorney, healthcare directives, and estate planning
- **Navigate Finances**: Understand care costs, Medicaid planning, and asset protection strategies
- **Facilitate Family Coordination**: Structure family meetings and distribute responsibilities fairly
- **Manage Healthcare**: Organize medical information, coordinate appointments, manage medications
- **Evaluate Living Arrangements**: Compare aging in place, assisted living, nursing homes, and memory care
- **Prevent Caregiver Burnout**: Recognize warning signs and build sustainable caregiving practices

## Structure

```
aging-parent-care-coordinator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r aging-parent-care-coordinator/ ~/.claude/skills/aging-parent-care-coordinator/
```

Then reference in your project or use globally.

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Create new GPT or paste into Custom Instructions
4. Save and use

### Gemini

1. Open `SKILL.md`
2. Copy the skill content
3. Start new conversation with skill content as system context
4. Continue with your eldercare questions

### Copilot / Other Assistants

1. Open `SKILL.md`
2. Copy the full prompt content
3. Paste at the beginning of your conversation
4. The AI will adopt the eldercare coordinator persona

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{caregiver_primary_location}}` | `same_city` | Your distance from parent: same_home, same_city, within_2hrs, different_state, long_distance |
| `{{aging_parent_health_status}}` | `independent_with_support` | Parent's functional level: fully_independent, independent_with_support, partial_assistance, substantial_assistance, dependent_care |
| `{{number_of_caregivers}}` | `2` | How many family members are actively involved (1-6+) |
| `{{available_budget_annual}}` | `0` | Annual budget available for care beyond insurance |
| `{{medicaid_planning_timeline}}` | `5` | Years until potential long-term care need (affects planning urgency) |
| `{{legal_document_completion_percent}}` | `0` | Current legal document completion status (0-100%) |

## Example Prompts

### Initial Assessment
```
My 72-year-old mom was just diagnosed with Parkinson's. She lives alone 30 minutes away.
I work full-time and have two kids. My brother is across the country. Where do I start?
```

### Sibling Conflict
```
My dad had a stroke. My siblings and I can't agree on what to do - one wants a nursing home,
one wants in-home care, one wants him to move in with them. Dad refuses to discuss any option.
How do we have this conversation without destroying our family?
```

### Medicaid Planning
```
My parents are in their 70s with about $1.2M in assets including their home. One has early
dementia. They might need nursing care eventually but don't want to lose everything.
Help me understand Medicaid planning and what we should do now.
```

### Care Coordination
```
I'm the primary caregiver for my 80-year-old father. I'm exhausted, my siblings barely help,
and I don't know how to ask for support without starting a fight. Can you help me create a
family meeting plan and fair responsibility distribution?
```

## Key Capabilities

1. **Care Assessment Frameworks**
   - ADL (Activities of Daily Living) evaluation
   - IADL (Instrumental Activities) assessment
   - Cognitive concern indicators
   - Home safety evaluation

2. **Legal Document Guidance**
   - Durable Power of Attorney
   - Healthcare Power of Attorney / Health Care Proxy
   - Living Will / Advance Directive
   - HIPAA Authorization
   - Will and Trust considerations

3. **Financial Planning**
   - Long-term care cost estimates
   - Medicaid eligibility and lookback rules
   - Asset protection strategies
   - Funding source analysis

4. **Family Coordination**
   - Family meeting facilitation
   - Role-based responsibility assignment
   - Conflict resolution techniques
   - Communication system recommendations

5. **Healthcare Management**
   - Medical record organization
   - Medication management systems
   - Appointment coordination
   - Emergency preparation

6. **Living Arrangement Guidance**
   - Aging in place assessment
   - Facility type comparison
   - Evaluation checklists
   - Transition planning

7. **Caregiver Support**
   - Burnout recognition
   - Self-care strategies
   - Respite care options
   - Support resource referrals

## Important Notes

- This skill provides guidance and organization frameworks, not legal or medical advice
- Recommend consulting professionals (elder law attorney, financial advisor, geriatric care manager) for complex situations
- State laws vary significantly for Medicaid and estate planning
- Every family situation is unique—adapt recommendations accordingly

## Related Skills

- [Family Dynamics Navigator](/skills/family-parenting/family-dynamics-navigator/)
- [Healthcare Navigation Guide](/skills/productivity/healthcare-navigation-guide/)
- [Stress Management](/skills/productivity/stress-management/)
- [Grief & Loss Processing Guide](/skills/productivity/grief-loss-processing-guide/)

---

Downloaded from [Find Skill.ai](https://findskill.ai)
