---
name: bedtime-story-creator
version: 1.0.0
description: Create personalized bedtime stories featuring your child's name, favorite things, and gentle life lessons
author: FindSkill.ai
license: MIT
---

# Initialization

A skill that creates magical, personalized bedtime stories for children ages 2-8. Each story features the child as the hero, incorporates their favorite things, and can gently address life challenges while guiding them toward peaceful sleep.

## Why This Skill?

Parents describe this as a "godsend" - it solves the creativity and energy drain of nightly storytelling while creating stories that are infinitely personalized. Research from the UK's Open University shows children acquire more vocabulary from personalized story sections than non-personalized ones, making these stories both comforting AND educational.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive story creation guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r bedtime-story-creator/ ~/.claude/skills/bedtime-story-creator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_name}}` | `Emma` | Your child's name to feature in the story |
| `{{child_age}}` | `5` | Age of your child (affects vocabulary and themes) |
| `{{favorite_things}}` | `unicorns, purple, stuffed bunny` | Favorite animals, toys, colors |
| `{{story_mood}}` | `calm and sleepy` | Desired tone (calm, adventurous, silly, magical) |
| `{{life_lesson}}` | `` | Optional challenge to address (fear of dark, new sibling, etc.) |

## Key Features

### Age-Appropriate Content
- **Ages 2-3**: Simple vocabulary, short sentences, basic plots
- **Ages 4-5**: Magic and wonder, friendship themes, medium complexity
- **Ages 6-8**: More sophisticated vocabulary, nuanced plots, independence themes

### Challenge Themes Available
- Fear of the dark
- New baby sibling
- Starting school/daycare
- Fear of monsters
- Moving to a new home
- Separation anxiety

### Story Structures
- The Magical Journey
- The Nighttime Helper
- The Dream Adventure
- The Cozy Problem-Solver

### Safety Guaranteed
- Always positive resolution
- Child characters always safe and loved
- No scary elements or nightmares
- Calming, sleep-inducing endings

## Example Usage

**Parent**: "Create a story for my 4-year-old son Marcus. He loves dinosaurs and his toy T-Rex named Chompy. He's anxious about his new baby sister arriving."

**AI Creates**: A personalized story where Marcus and Chompy discover that being a big brother is the greatest adventure of all, ending with Marcus and Chompy (and baby sister) all cozy and sleepy together.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
