---
name: behavior-chart-designer
version: 1.0.0
---

# Behavior Chart Designer - Initialization

Create age-appropriate positive reinforcement behavior charts for children 2-12 using evidence-based token economies, sticker charts, and intrinsic motivation strategies.

## What This Skill Does

This skill transforms your AI assistant into an expert child development specialist who designs:

- **Complete behavior chart systems** tailored to your child's age (2-12) and specific challenges
- **Six chart types** including sticker charts, token economies, marble jars, point systems, behavior bingo, and zones of regulation visuals
- **Positive behavior framing** that converts "don't" statements into observable, achievable targets
- **Tiered reward menus** emphasizing non-material rewards and family connection
- **Phase-out plans** for transitioning from external rewards to intrinsic motivation
- **Special accommodations** for ADHD, autism spectrum, anxiety, and sensory processing differences
- **Printable templates** ready for immediate household use

## Package Structure

```
behavior-chart-designer/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r behavior-chart-designer/ ~/.claude/skills/behavior-chart-designer/
```

Then reference in your conversation:
```
Use the behavior-chart-designer skill to help me create a behavior chart for my child.
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a Custom Instruction or at the start of your conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter
3. Paste into your AI assistant as context or system prompt

## Variables

Customize the skill by mentioning these in your prompt:

| Variable | Default | Description |
|----------|---------|-------------|
| `child_age` | `5 years` | Age of the child (2-12). Determines chart complexity, reward frequency, and developmental expectations. |
| `target_behaviors` | `morning routine, homework completion, kind words` | Specific behaviors to encourage (e.g., brushing teeth, staying in bed, using kind words) |
| `reward_preferences` | `mixed` | Types of rewards: `material`, `experience-based`, `privilege-based`, or `mixed` |
| `chart_style` | `sticker_chart` | Chart format: `sticker_chart`, `token_economy`, `marble_jar`, `point_system`, `behavior_bingo`, `zones_visual` |
| `family_values` | `kindness, responsibility` | Core values to reinforce (e.g., kindness, responsibility, perseverance, teamwork) |

## Example Usage

### Morning Routine Sticker Chart
```
My 4-year-old can't get through the morning routine without 10 reminders.
I want a sticker chart for getting dressed, brushing teeth, and eating breakfast.
She loves unicorns and is motivated by experience rewards.
```

### Token Economy for Homework
```
My 8-year-old fights homework every single day. I've tried yelling, taking away screen time,
and bribing with candy. Nothing works. Design a token economy system where he can earn
rewards for completing homework calmly.
```

### Sibling Behavior System
```
I have a 5-year-old and a 7-year-old who constantly fight. I need a system that encourages
kindness and cooperation between them without creating competition. We value teamwork and gentleness.
```

### Marble Jar for Family Goals
```
We want to build a family culture of kindness and helpfulness. Design a marble jar system
that all three of our kids (ages 3, 6, and 9) can contribute to with age-appropriate expectations.
```

### ADHD-Friendly Chart
```
My 6-year-old has ADHD and can't follow through on tasks. Traditional sticker charts
haven't worked because he forgets about them by lunchtime. What system would work
for his brain wiring?
```

### Phasing Out an Existing Chart
```
My daughter has been on a sticker chart for 3 months for brushing teeth and she does it
automatically now. How do I phase out the chart without her regressing?
```

## Key Concepts

- **Positive framing**: State what the child SHOULD do, never what they should NOT do
- **Camera test**: Every behavior must be observable enough that a camera could capture it
- **80% success rule**: Charts should be designed so the child succeeds at least 80% of the time in week one
- **Scaffolding metaphor**: External rewards are temporary scaffolding; intrinsic motivation is the building
- **Never remove earned rewards**: Tokens, stickers, and marbles once earned are permanent
- **One variable at a time**: When adjusting the system, change only one thing per week

## Evidence Base

This skill integrates:
- Applied Behavior Analysis (ABA) - positive reinforcement principles
- Self-Determination Theory (Deci & Ryan) - intrinsic motivation research
- Positive Behavioral Interventions and Supports (PBIS) - school and home frameworks
- CDC Developmental Milestones - age-appropriate expectations
- Token economy research - systematic reviews of effectiveness

## Disclaimer

This skill provides general parenting guidance based on established child development research. It is not a substitute for professional evaluation or treatment. If your child's behavior challenges persist despite consistent use of positive reinforcement systems, or if you suspect ADHD, autism, anxiety, or other developmental concerns, consult a pediatrician, child psychologist, or behavioral specialist.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
