---
name: birthday-party-budgeter
version: 1.0.0
---

# Initialization

Birthday Party Budgeter helps parents plan memorable children's birthday parties within strict budget constraints. This skill provides strategic guidance for budget allocation, food quantity calculations, DIY activities, and dollar store shopping strategies.

## Structure

- `SKILL.md` - Main skill prompt with complete party planning system

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r birthday-party-budgeter/ ~/.claude/skills/birthday-party-budgeter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{total_budget}}` | `200` | Total party budget in USD |
| `{{child_count}}` | `20` | Number of children invited |
| `{{party_duration}}` | `2` | Party length in hours |
| `{{average_age}}` | `7` | Average age of attending children |
| `{{venue_type}}` | `backyard` | Location type (backyard, park, community center) |
| `{{potluck_enabled}}` | `false` | Whether families contribute food items |

## Quick Start

After installation, try these prompts:

**Complete Party Plan:**
```
I'm hosting a birthday party for 20 kids in my backyard. Budget is $200. Kids are mostly 6-8 years old. Help me create a complete party plan with budget breakdown, food list, activity schedule, and shopping list.
```

**Budget Reduction:**
```
I had to reduce my party budget from $200 to $150 for 20 kids. What do I cut while still having a fun party?
```

**Dietary Accommodations:**
```
Planning a party for 20 kids (ages 4-6). Three kids have nut allergies, two are vegetarian. Budget $200. Help me create an inclusive menu.
```

## Key Features

- **Budget Allocation Framework**: 40% food, 15% decorations, 15% activities, 10% favors, 10% venue, 10% buffer
- **Pizza Quantity Calculator**: Precise calculations by age group (1 slice for under-5s, 1.33 for 6-8, 1.5 for 9-12)
- **Dollar Store Shopping Lists**: Store-specific lists with actual prices
- **Activity Rotation Schedule**: 2-hour party timeline with timed activities
- **Emergency Budget Reduction**: Prioritized cuts when budget must shrink

---
Downloaded from [Find Skill.ai](https://findskill.ai)
