---
name: child-development-milestone-tracker
version: 1.0.0
---

# Child Development Milestone Tracker - Initialization

Track age-appropriate developmental milestones from birth to 5 years across motor, cognitive, language, and social-emotional domains with activities and red-flag guidance.

## What This Skill Does

This skill transforms your AI assistant into an expert child development specialist who provides:

- **Comprehensive milestone checklists** for 11 age points from 2 months through 5 years across five developmental domains
- **Five domains tracked** -- gross motor, fine motor, cognitive, language/communication, and social-emotional
- **Adjusted age calculation** for premature babies with guidance on when to transition to chronological age
- **Bilingual development guidance** including what is normal, when to be concerned, and how to support multiple languages
- **"Act Early" red flags** at every age point with specific guidance on when to consult a pediatrician
- **Play-based activities** for every domain at every age using everyday materials and interactions
- **Social development stages** explained (solitary, onlooker, parallel, associative, cooperative play)
- **Fine motor progression** from reflexive grasp through dynamic tripod pencil grip
- **Screen time guidance** by age with evidence-based recommendations
- **Early intervention navigation** for Part C (birth to 3) and Part B (ages 3-5) services
- **Common worry reassurance** addressing top parental concerns that are actually normal

## Package Structure

```
child-development-milestone-tracker/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r child-development-milestone-tracker/ ~/.claude/skills/child-development-milestone-tracker/
```

Then reference in your conversation:
```
Use the child-development-milestone-tracker skill to help me check my child's developmental milestones.
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a Custom Instruction or at the start of your conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter
3. Paste into your AI assistant as context or system prompt

## Variables

Customize the skill by mentioning these in your prompt:

| Variable | Default | Description |
|----------|---------|-------------|
| `child_age_months` | `12` | Child's age in months (0-60). Determines which milestone checklist and activities are presented. |
| `developmental_concerns` | `none` | Specific concerns the parent has observed (e.g., not babbling, not walking, limited eye contact, speech delay) |
| `areas_of_interest` | `all` | Which developmental domains to focus on: `gross_motor`, `fine_motor`, `cognitive`, `language`, `social_emotional`, `adaptive`, or `all` |
| `child_context` | `typical` | Birth context: `typical`, `premature` (include gestational age), `multiples`, `adopted`, or other relevant context |
| `language_environment` | `monolingual` | Home language situation: `monolingual`, `bilingual`, `multilingual` with languages spoken |

## Example Usage

### Full Milestone Check
```
My son is 12 months old. He can pull to stand and cruise along furniture, but he's
not walking yet. He says "dada" but not "mama." He was full-term and we speak only
English at home. Can you give me a complete milestone check?
```

### Premature Baby Assessment
```
My daughter was born at 28 weeks and is now 10 months old chronologically.
I'm worried she's not sitting up well yet. Can you check her milestones
using her adjusted age?
```

### Bilingual Development Check
```
We speak Mandarin at home and my 2-year-old is in an English-speaking daycare.
She has about 15 words in Mandarin and 10 in English. Her daycare teacher
says she should have more words. Is this normal for bilingual kids?
```

### Specific Concern
```
My 18-month-old doesn't point at things to show me. He also doesn't seem
interested in other kids at all. He lines up his toy cars instead of
playing with them. Should I be worried?
```

### Activity Ideas for a Domain
```
My 3-year-old is great at gross motor skills but seems behind on fine motor.
She can't hold a crayon well and hasn't tried using scissors.
What activities can I do at home to help?
```

### When to Seek Help
```
My 15-month-old isn't walking yet. My mother-in-law keeps saying she should
be walking by now and something must be wrong. What's the normal range and
when should I actually worry?
```

## Key Concepts

- **Milestone ranges, not deadlines**: Development is a spectrum. Walking at 9 months and walking at 16 months are both normal.
- **Adjusted age for preemies**: Use corrected age (chronological age minus prematurity) until age 2-3.
- **Total vocabulary for bilinguals**: Count words across ALL languages, not just one.
- **"Act Early" signs**: Specific red flags at each age that warrant a pediatrician conversation.
- **Play is learning**: Structured academics before age 5 are unnecessary. Play-based activities drive development.
- **Sequence over timeline**: The order of milestones matters more than the exact age they appear.
- **Every child is different**: Population-level data provides guidance, not rigid rules for individual children.

## Evidence Base

This skill integrates:
- CDC "Learn the Signs. Act Early." program (2022 revision) -- evidence-based milestone checklists
- WHO Multicentre Growth Reference Study -- international motor development standards
- Ages and Stages Questionnaires (ASQ-3) -- validated developmental screening framework
- Zero to Three -- research-based early childhood development resources
- AAP Bright Futures -- pediatric health supervision guidelines including developmental surveillance

## Disclaimer

This skill provides general developmental information based on established child development research. It is NOT a diagnostic tool and cannot replace professional evaluation. If you have concerns about your child's development, consult your pediatrician or request an evaluation through your state's early intervention program (Part C for birth to age 3) or school district (Part B for ages 3-5). Developmental milestones represent population-level data and every child develops at their own pace. Early intervention is most effective when started early -- when in doubt, seek professional guidance.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
