---
name: college-application-strategist
version: 1.0.0
description: Strategic college application guidance for parents and students covering school selection, essay review, financial aid, timelines, and recommendations
author: FindSkill.ai
license: MIT
---

# Initialization

A comprehensive skill that guides parents and students through the entire college application process — from sophomore year planning through decision day. Unlike essay-writing tools, this skill focuses on strategy, structure, and review, helping students present their authentic selves rather than generating content for them.

## Why This Skill?

College admissions has become increasingly complex. The average student applies to 8-12 schools, navigates multiple essay prompts, decodes financial aid packages, and makes decisions worth hundreds of thousands of dollars — often without access to a private college counselor. This skill provides the strategic framework that families need to make informed decisions and stay organized through a multi-month, high-stakes process.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive college application strategy guidance
- `index.md` - Hugo page with full frontmatter and extended skill content

## Key Capabilities

### Application Timeline Management
- Month-by-month planning from sophomore year through senior spring
- Clear milestones and deadlines for each phase
- Customizable based on where the student currently stands

### School List Building
- Reach / Match / Safety framework for balanced school lists
- Four-dimensional fit evaluation: Academic, Social, Financial, Career
- Red flags in school selection

### Essay Strategy and Review
- Common App personal statement prompt analysis
- Brainstorming techniques (Moments, Values, Others See Me, Dinner Table Test)
- Draft review criteria across five dimensions (Structure, Authenticity, Depth, Specificity, Impact)
- Supplemental essay type guidance (Why This School, Why This Major, Community, Activity)
- Emphasis on review and feedback — NOT essay writing

### Financial Aid Navigation
- FAFSA and CSS Profile guidance
- Net Price Calculator strategy
- Financial aid offer comparison framework
- Appeal strategies with documentation guidance
- Merit aid optimization

### Recommendation Letter Strategy
- Who to ask and when
- How to provide a recommendation packet
- Counselor recommendation preparation

### Additional Frameworks
- Early Action vs. Early Decision decision matrix
- Extracurricular presentation and Activities section optimization
- Interview preparation
- Waitlist strategy
- Gap year considerations
- First-generation student guidance
- Transfer student considerations

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r college-application-strategist/ ~/.claude/skills/college-application-strategist/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{student_grade}}` | `11th grade (junior)` | Current grade level of the student |
| `{{intended_major}}` | `undecided` | Student's intended major or area of interest |
| `{{budget_range}}` | `$20,000-$35,000 per year` | Family budget range for annual college costs |
| `{{geographic_preference}}` | `within 500 miles of home` | Preferred region or distance from home |
| `{{application_type}}` | `regular` | Application strategy (early_action, early_decision, regular, rolling) |

## Example Usage

**Parent**: "My daughter is a junior with a 3.7 GPA and 1380 SAT. She's interested in environmental science and wants to stay on the East Coast. Our budget is about $30K/year after financial aid. She has strong extracurriculars in debate and environmental club but hasn't started her Common App essay yet. Can you help us build a strategy?"

**AI Response**: The skill will:
1. Assess the student's profile against target school ranges
2. Suggest a balanced school list with reaches, matches, and safeties
3. Provide a timeline for essay writing based on current date
4. Identify financial aid strategies for the family's budget
5. Recommend brainstorming exercises for the personal statement
6. Outline next steps for recommendations and supplemental essays

---
Downloaded from [Find Skill.ai](https://findskill.ai)
