---
name: family-budget-simplifier
version: 1.0.0
---

# Family Budget Simplifier - Initialization

Teach kids about money with age-appropriate lessons, allowance systems, Save-Spend-Give jars, family budget templates, and financial literacy activities the whole family can use.

## What This Skill Does

This skill transforms your AI assistant into a family financial literacy coach who helps parents:

- **Teach money at every age** with developmentally appropriate lessons for children 3-5, 6-8, 9-12, and 13+
- **Set up allowance systems** choosing from four models: flat-rate, commission-based, hybrid, or chore-chart-pay
- **Implement the Save-Spend-Give jar system** with age-adjusted ratios and a transition path from physical jars to real bank accounts
- **Organize the family budget** using a simplified needs/wants/savings framework with printable templates
- **Run family money meetings** with a kid-friendly monthly agenda that celebrates wins and plans ahead
- **Handle difficult money questions** like "Are we rich?" or "Why can't we buy that?" with age-appropriate scripts
- **Support kid entrepreneurs** with business plan templates covering costs, revenue, and profit
- **Teach about advertising and impulse buying** with the Ad Decoder Game and defense strategies
- **Plan seasonal budgets** for back-to-school, holidays, and birthdays with kid involvement

## Package Structure

```
family-budget-simplifier/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r family-budget-simplifier/ ~/.claude/skills/family-budget-simplifier/
```

Then reference in your conversation:
```
Use the family-budget-simplifier skill to help me create a family money plan.
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a Custom Instruction or at the start of your conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter
3. Paste into your AI assistant as context or system prompt

## Variables

Customize the skill by mentioning these in your prompt:

| Variable | Default | Description |
|----------|---------|-------------|
| `family_size` | `4 (two adults, two children)` | Number of household members including adults and children |
| `monthly_income_range` | `$5,000-$7,000` | Approximate monthly household income (used for proportional budgeting, not stored) |
| `children_ages` | `5, 8` | Ages of all children in the household, separated by commas |
| `financial_goals` | `build emergency fund, save for family vacation` | Top family financial priorities |
| `allowance_preference` | `hybrid` | Preferred allowance model: `flat-rate`, `commission-based`, `hybrid`, or `chore-chart-pay` |

## Example Usage

### Setting Up a First Allowance
```
My kids are 6 and 9. We have never given allowance before and have no system.
Our household income is about $5,500/month. We want to teach them about saving
and help them understand that money does not grow on trees. What system should
we use and how much should we give?
```

### Full Family Money Plan
```
We are a family of five -- two parents and three kids ages 4, 8, and 11.
Our household income is around $6,500/month. The 8-year-old wants an
allowance but we have no system. The 11-year-old spends birthday money
within hours. The 4-year-old melts down at the grocery store when we say no.
Help us build a whole family money plan!
```

### Family Budget Organization
```
We make about $7,000/month but can never figure out where the money goes.
We have two kids (ages 7 and 10) and want to get our family budget under
control while also teaching the kids about money. We spend way too much
on eating out and subscriptions.
```

### Teaching a Specific Concept
```
My 10-year-old wants everything she sees advertised on YouTube. How do I
teach her about advertising tricks and impulse buying without making her
feel bad? She gets $8/week allowance.
```

### Kid Entrepreneur Support
```
My 9-year-old wants to start a lemonade stand this summer. I want to use
this as a real money learning experience. Help me walk him through
planning the business, understanding costs vs. revenue, and what to do
with the profit.
```

### Handling a Hard Question
```
My 7-year-old came home from school and asked "Are we poor?" because his
friend has a bigger house and nicer toys. I froze and didn't know what
to say. What should I tell him?
```

## Key Concepts

- **Save-Spend-Give jars**: The foundational system teaching that every dollar has a job before it arrives
- **Needs vs. wants framework**: Simple categories the whole family can understand and discuss
- **Hybrid allowance**: Baseline for being a family member, extras for above-and-beyond work
- **Family Job Board**: A visible board where parents post extra-pay tasks kids can claim
- **Family money meeting**: Monthly 20-30 minute agenda that makes money conversations normal and positive
- **The 48-hour rule**: Wait two days before any non-essential purchase over a set threshold
- **Ad Decoder Game**: Watch ads together and identify emotional manipulation, missing information, and tricks
- **Opportunity cost**: "Every time we spend on one thing, we choose NOT to spend on something else"
- **No bailouts**: When a child spends all their money, empathize but do not replace it -- the lesson is the point
- **Progress, not perfection**: Financial habits build over time; celebrate effort and learning from mistakes

## Research Foundation

This skill integrates:
- T. Rowe Price Parents, Kids & Money Survey -- annual data on how families teach money habits
- Consumer Financial Protection Bureau (CFPB) Money as You Grow -- age-by-age financial milestones
- Jump$tart Coalition National Standards -- K-12 personal finance education benchmarks
- American Institute of CPAs teaching resources -- practical allowance and saving frameworks
- Ron Lieber's research (The Opposite of Spoiled) -- values-driven approach to raising financially grounded children

## Related Skills

- **Teen Money Skills Builder**: Deep curriculum for teenagers on first jobs, credit building, investing, and college costs
- **Behavior Chart Designer**: Positive reinforcement systems that complement chore-based allowance structures
- **Screen Time Negotiator**: Family agreement frameworks using similar negotiation and meeting structures

## Disclaimer

This skill provides general financial education guidance for families. It is not professional financial advice. Every family's financial situation is different, and recommendations should be adapted to your specific circumstances. For complex financial planning, tax questions, or debt management, consult a certified financial planner or credit counselor.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
