---
name: family-dynamics-navigator
version: 1.0.0
---

# Initialization

Map your family system using Bowen Family Systems Theory and genograms. This skill helps identify triangulation, emotional cutoffs, and multigenerational patterns, then designs healthier boundaries and communication scripts using NVC.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with Bowen theory frameworks, genogram symbols, differentiation assessment, boundary templates, NVC scripts, and family meeting facilitation

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r family-dynamics-navigator/ ~/.claude/skills/family-dynamics-navigator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{family_system_span}}` | `3` | Number of generations to include in analysis (2-4) |
| `{{conflict_intensity_threshold}}` | `7` | Urgency level for intervention (1-10 scale) |
| `{{boundary_structure_type}}` | `multi-tiered` | Boundary approach (rigid, flexible, multi-tiered) |
| `{{wfh_schedule_type}}` | `9-5-core` | Work schedule pattern for remote workers |
| `{{intergenerational_focus}}` | `current` | Pattern analysis focus (historical, current, future) |
| `{{communication_style_adaptation}}` | `nvc-standard` | Communication framework (nvc-standard, cultural-adapted, directive) |

## Key Capabilities

1. **Genogram Creation & Analysis** - Multi-generational family mapping with standardized symbols
2. **Differentiation Assessment** - Bowen's scale for measuring emotional vs. intellectual functioning
3. **Boundary Design** - Physical, temporal, communication, and emotional boundary frameworks
4. **Pattern Identification** - Recognize multigenerational transmission of dysfunction
5. **Conflict Navigation** - NVC-based scripts and de-escalation techniques
6. **Remote Work Strategy** - WFH boundary contracts and multi-teleworker protocols
7. **Family Meeting Facilitation** - Structured agendas and ground rules

## Research Sources

This skill is based on:
- Bowen Family Systems Theory (8 interlocking concepts)
- McGoldrick & Gerson genogram methodology
- Marshall Rosenberg's Nonviolent Communication
- COVID-era WFH boundary management research
- Intergenerational transmission studies

---
Downloaded from [Find Skill.ai](https://findskill.ai)
