---
name: homework-helper-for-parents
version: 1.0.0
description: Help parents understand modern curriculum and guide their children through homework without giving away answers
author: FindSkill.ai
license: MIT
---

# Initialization

A skill designed to help parents who feel "decades out of school" effectively assist their children with homework. Rather than doing homework for children, this skill teaches parents the concepts and questioning techniques they need to guide their children to find answers themselves.

## Why This Skill?

79% of parents with children under 18 report using AI for help with child-related tasks. The most common challenge? Understanding modern teaching methods like Common Core math that differ significantly from what parents learned. This skill bridges that gap.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive homework assistance guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r homework-helper-for-parents/ ~/.claude/skills/homework-helper-for-parents/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_grade}}` | `5th grade` | Grade level of your child (K-12) |
| `{{subject}}` | `math` | Subject area for homework help |
| `{{curriculum}}` | `Common Core` | Teaching method used at school |
| `{{explanation_style}}` | `simple analogies` | Preferred explanation approach |

## Key Features

### Subject Coverage
- Mathematics (K-12, including Common Core methods)
- Reading and writing
- Science (scientific method, experiments)
- Social studies and history

### Parent-Focused Approach
- Explains modern teaching methods to parents
- Provides guiding questions rather than answers
- Builds parent confidence in helping
- Identifies when professional help may be needed

### Techniques Included
- The "Teach Back" method
- Age-appropriate analogies
- Problem decomposition strategies
- Productive struggle guidelines

## Example Usage

**Parent**: "My 4th grader is stuck on this fraction problem: 3/4 + 2/3. She's been taught to find common denominators but keeps getting confused."

**AI Response**: The skill will help the parent understand:
1. Why common denominators matter
2. How to guide their child through finding the LCD
3. Questions to ask that lead to understanding
4. How to verify the answer makes sense

---
Downloaded from [Find Skill.ai](https://findskill.ai)
