---
name: kids-activity-generator
version: 1.0.0
description: Generate age-appropriate activities for kids based on available materials, weather, time, and energy level
author: FindSkill.ai
license: MIT
---

# Initialization

A skill that generates engaging, age-appropriate activities for children based on specific constraints: available materials, weather, time, and energy levels. Designed to combat the constant parental decision fatigue of "What should we do?"

## Why This Skill?

34% of parents use AI for childcare management. The most common pain point? The endless "I'm bored!" combined with the mental load of constantly generating activity ideas. This skill provides instant, contextual suggestions that work with what families actually have available.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive activity generation guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r kids-activity-generator/ ~/.claude/skills/kids-activity-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_age}}` | `6` | Age(s) of children needing activities |
| `{{time_available}}` | `30 minutes` | How much time you have |
| `{{location}}` | `indoor` | Indoor or outdoor (or both) |
| `{{energy_level}}` | `moderate` | High energy or calm activities needed |
| `{{materials}}` | `paper, crayons` | Materials available |

## Key Features

### Age Coverage
- **Toddlers (1-3)**: Sensory play, simple motor activities
- **Preschoolers (3-5)**: Imaginative play, simple crafts
- **Early Elementary (5-8)**: Building, experiments, games
- **Older Kids (8-12)**: Complex projects, skill-building

### Activity Categories
- High energy indoor
- Calm indoor
- Outdoor activities
- Educational disguised as fun
- Screen-free entertainment

### Special Situations
- Quick 15-minute activities
- Rainy day solutions
- Energy-burning options
- Wind-down activities
- Keep-them-occupied activities
- Long car trip games

### Multi-Age Support
- Same activity, different levels
- Buddy system pairing
- Collaborative projects

## Example Usage

**Parent**: "It's rainy, my 5 and 8 year old have too much energy, I have cardboard boxes and markers, and I need to get work done."

**AI Response**: Customized activities like:
1. Cardboard Box Fort Challenge - they design and build while you work
2. Indoor Obstacle Course - burn energy, then calm down
3. Mystery Box Craft Challenge - independent activity with clear goals

---
Downloaded from [Find Skill.ai](https://findskill.ai)
