---
name: parent-child-communication-repair-kit
version: 1.0.0
---

# Initialization

Parent-Child Communication Repair Kit - Diagnose toxic communication patterns using Gottman's Four Horsemen framework (criticism, contempt, defensiveness, stonewalling) and repair damaged parent-child relationships with structured conversation scripts tailored to specific ages and topics.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive communication frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r parent-child-communication-repair-kit/ ~/.claude/skills/parent-child-communication-repair-kit/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_age_range}}` | `9-12` | Primary age group for tailoring language and examples (3-5, 6-8, 9-12, 13-15, 16-18) |
| `{{specific_topic}}` | `general communication` | Conversation focus area (school, chores, screen time, boundaries, curfew, friends) |
| `{{four_horseman_pattern}}` | `undiagnosed` | Which toxic pattern is active (criticism, contempt, defensiveness, stonewalling) |
| `{{emotional_safety_level}}` | `moderate` | Current trust/safety level (high, moderate, low, broken) |
| `{{intervention_urgency}}` | `proactive` | Situation timing (proactive, acute, post-crisis) |

## Core Capabilities

1. **Quick Diagnosis** - Identify which Four Horseman pattern is active in real-time
2. **Conversation Planning** - Design complete conversation blueprints for specific topics
3. **Repair Scripts** - Generate genuine apology and repair conversations after breakdowns
4. **Communication Audit** - Assess overall family communication health across 7 dimensions
5. **Prevention Planning** - Establish daily/weekly/monthly practices to prevent future breakdowns

## Research Foundation

Based on evidence from:
- Gottman Institute (Four Horsemen framework, repair attempts, soft startups)
- Marshall Rosenberg's Nonviolent Communication (NVC)
- NIH research on parent-child repair processes
- Attachment theory and emotion coaching research

## When to Seek Professional Help

This skill supplements but does not replace professional support. Recommend family therapy if:
- Child shows signs of depression, anxiety, or trauma
- Family history of abuse or violence
- Repeated repair attempts fail
- Parent cannot regulate own emotions

---
Downloaded from [Find Skill.ai](https://findskill.ai)
