---
name: rainy-day-activity-jar
version: 1.0.0
---

# Rainy Day Activity Jar

Create a curated jar of low-prep, screen-free activity ideas for bored kids. Generate age-appropriate activities, organize by type, and build a system that eliminates "I'm bored" moments.

## What This Skill Does

This skill helps parents, caregivers, and educators create customized activity jars filled with:
- Age-appropriate activities (toddler, preschool, elementary)
- Low-prep options using common household items
- Diverse activity types (creative, physical, sensory, learning, pretend play)
- Printable card formats ready to cut and use
- Maintenance schedules to keep the jar fresh and engaging

## Structure

```
rainy-day-activity-jar/
├── SKILL.md      # Main skill prompt with full instructions
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r rainy-day-activity-jar/ ~/.claude/skills/rainy-day-activity-jar/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `child_age_group` | `preschool` | Target age: toddler (2-3), preschool (3-5), elementary (5-12), or mixed |
| `activity_count` | `30` | Number of activities to generate (15-50 recommended) |
| `activity_types` | `mixed` | Emphasis: mixed, creative-heavy, active-heavy, sensory-heavy, learning-heavy, pretend-heavy |
| `prep_time_limit` | `5_minutes` | Maximum setup time: 0_minutes, 5_minutes, 15_minutes, 30_minutes |
| `indoor_only` | `true` | Restrict to indoor activities (true/false) |
| `supply_constraints` | `common_household_items` | Available materials: common_household_items, dollar_store_items, any_craft_supplies |

## Example Usage

**Basic request:**
```
Create a rainy day activity jar for my 4-year-old with 25 activities.
```

**Detailed request:**
```
Create a rainy day activity jar for my 4-year-old. I need 30 activities
that require almost no setup, use things I already have at home, and mix
creative, active, sensory, and pretend play activities. Include some
silly options. Format them so I can print, cut, and put in a jar.
```

**Multi-age household:**
```
I have a 3-year-old and a 7-year-old. Create three activity jars: one
for each child alone and one they can do together. Each jar should have
20 activities. Color-code by age group.
```

## Activity Categories Included

- **Creative**: Drawing, coloring, crafting, collages, paper crafts
- **Physical/Active**: Dance parties, obstacle courses, freeze dance, yoga
- **Sensory**: Playdough, sensory bins, water play, texture exploration
- **Learning**: Puzzles, board games, scavenger hunts, building challenges
- **Pretend Play**: Role-playing, puppet shows, dress-up, imagination games
- **Quiet/Calming**: Reading, audiobooks, gentle activities, organizing

## Age Guidelines

| Age Group | Attention Span | Activity Complexity |
|-----------|----------------|---------------------|
| Toddler (2-3) | 5-15 min | 1-2 step activities |
| Preschool (3-5) | 15-30 min | 2-4 step activities |
| Elementary (5-12) | 30-60 min | Multi-step projects |

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Same activities picked | Add novelty, use mystery draw rule |
| Short attention | Check age-appropriateness, shorten scope |
| Want parent involvement | Add independent activities, practice gradual release |
| Won't do any | Check for hunger/tiredness, offer limited choice |
| Too messy | Create low-mess category, designate messy play area |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
