---
name: school-bullying-email-drafter
version: 1.0.0
---

# School Bullying Email Drafter - Initialization

A comprehensive skill for helping parents and guardians draft professional, documented emails to teachers and school administrators about bullying incidents. Creates paper trails, follows proper escalation procedures, and maintains collaborative tone while advocating effectively for children.

## Structure

```
school-bullying-email-drafter/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## What This Skill Does

When activated, the AI will:

1. **Gather incident information** - Ask for date, time, location, description, witnesses, impact
2. **Select appropriate email type** - Initial report, pattern documentation, follow-up, escalation, or meeting summary
3. **Draft professional email** - Using proper structure, factual language, and collaborative tone
4. **Guide escalation** - Advise when to move up the chain (teacher → principal → superintendent → board)
5. **Provide follow-up guidance** - Expected timelines, what to document, next steps

## Email Types Supported

| Type | When to Use | Recipients |
|------|-------------|------------|
| Initial Incident | First report of a bullying event | Teacher only |
| Pattern Documentation | 3+ incidents documented | Teacher + Principal (CC) |
| Follow-Up to Inaction | No response or continued bullying | Original + next level (CC) |
| Escalation | School-level efforts failed | Superintendent or Board |
| Meeting Summary | After any verbal conversation | Meeting attendees |

## Post-Init Steps

### For Claude Code
```bash
cp -r school-bullying-email-drafter/ ~/.claude/skills/school-bullying-email-drafter/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Begin by describing your situation

## Example Usage

```
"My 8-year-old daughter came home upset. She said that during lunch at 12:15pm,
a girl named Sarah took her sandwich and told her 'nobody wants to eat with you.'
This happened in the cafeteria and two other girls saw it. Emma has been anxious
about school for a week. I need to email her teacher Mrs. Johnson but don't know
how to word it professionally. Can you help?"
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `child_name` | `[Your child's name]` | Full name for documentation |
| `bullying_student` | `[Other student or 'a student']` | Name of student involved |
| `incident_date` | `[MM/DD/YYYY]` | Specific date of incident |
| `incident_time` | `[HH:MM AM/PM]` | Approximate time |
| `incident_location` | `[Cafeteria/playground/etc.]` | Where it occurred |
| `witness_names` | `[Names or descriptions]` | Anyone who saw it |
| `child_impact` | `[Academic/emotional/physical]` | Effects on your child |
| `requested_action` | `[Specific request]` | What you want school to do |
| `response_deadline` | `[Specific date]` | Timeline for response |
| `escalation_level` | `[Teacher/Principal/etc.]` | Who you're addressing |
| `previous_reports` | `[Prior communications]` | Previous emails/meetings |
| `school_policy` | `[Policy name]` | District anti-bullying policy |

## Key Principles

### DO
- Be specific (dates, times, locations, quotes)
- Use factual language (what happened, not interpretation)
- Stay collaborative ("I'm confident we can work together...")
- Request specific actions with deadlines
- Document everything in writing

### DON'T
- Send emails when angry (wait 2+ hours, reread)
- Accuse or blame ("You're not doing your job")
- CC everyone from the start (escalate gradually)
- Make empty threats (only if you'll follow through)
- Rely on verbal communication alone

## Escalation Chain

```
1. Classroom Teacher (first contact)
       ↓ (if no response in 5 days)
2. Principal/VP
       ↓ (if school-level fails)
3. Superintendent
       ↓ (if still unresolved)
4. School Board Trustee
       ↓ (final escalation)
5. District Office / Department of Education
```

## Red Flags (Immediate Escalation)

Skip normal process for:
- Physical harm or threats
- Sexual harassment
- Discrimination (race, disability, gender identity)
- Weapons involved
- Suicidal ideation
- Retaliation after reporting

## Expected Response Timelines

| Stage | Timeline |
|-------|----------|
| Initial acknowledgment | 1-2 school days |
| Substantive response | 3-5 school days |
| Investigation | 1-2 weeks |
| Action plan | 1-2 weeks |
| Follow-up if no response | 5 school days |
| Escalate if still no response | 10-15 school days |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
