---
name: school-email-composer
version: 1.0.0
---

# School Email Composer - Initialization

A comprehensive skill for helping parents and guardians write professional, effective emails to teachers, principals, school counselors, and administrators. Covers 20+ communication scenarios including academic concerns, accommodation requests, absence notifications, special services, and formal escalation.

## Structure

```
school-email-composer/
├── SKILL.md    # Main skill prompt (condensed version)
├── INIT.md     # This initialization file
└── index.md    # Full skill content (500+ lines with all templates)
```

## Files to Generate

None required. This is a prompt-only skill.

## What This Skill Does

When activated, the AI will:

1. **Gather context** - Ask who you are emailing, why, your child's grade, and what outcome you want
2. **Recommend a tone level** - Friendly, Professional, Assertive, or Formal Complaint based on the situation
3. **Draft a complete email** - Using the appropriate template with proper structure and language
4. **Provide a subject line** - Using proven formulas that get emails opened and read
5. **Include follow-up guidance** - Expected response timelines, escalation paths, documentation tips

## Email Scenarios Supported (20+)

| Category | Scenarios |
|----------|-----------|
| **Academic** | Grade concerns, homework load, test accommodations, gifted program inquiry, tutoring request |
| **Behavioral/Social** | Behavior report response, social concerns, teacher conflict |
| **Administrative** | Absence notification, early pickup, schedule change, enrollment, transfer |
| **Special Services** | 504 plan request, IEP meeting, counselor referral, speech/OT services |
| **Positive** | Thank-you notes, volunteer offers, end-of-year appreciation, event participation |
| **Escalation** | Complaint to principal, district-level concern, formal accommodation request |
| **Follow-Up** | Polite follow-up, firm follow-up, post-meeting summary |

## Tone Calibration

| Level | Name | When to Use |
|-------|------|-------------|
| 1 | Friendly | Thank-yous, first contact, minor requests |
| 2 | Professional | Standard requests, academic concerns, conferences |
| 3 | Assertive | Follow-ups, unresolved concerns, formal requests |
| 4 | Formal Complaint | Escalation, policy violations, legal framework |

## Post-Init Steps

### For Claude Code
```bash
cp -r school-email-composer/ ~/.claude/skills/school-email-composer/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Describe your situation and who you need to email

## Example Usage

```
"My son is in 5th grade and his math grades have been slipping for the past
month. I'd like to email his teacher to ask what's going on, whether there's
something I should be doing at home, and to request a conference. I want to
sound concerned but cooperative, not like I'm blaming the teacher."
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `recipient_role` | `teacher` | Who you are emailing (teacher, principal, counselor, admin) |
| `email_purpose` | `requesting a parent-teacher conference` | The reason for the email |
| `child_grade` | `3rd grade` | Your child's current grade level |
| `tone_preference` | `friendly-professional` | How formal or assertive the email should be |
| `urgency_level` | `standard` | How urgent the matter is |

## Key Principles

### DO
- Be specific about what you need and by when
- Use factual, non-accusatory language
- Start with the teacher before escalating
- Document everything in writing
- Send a summary email after phone calls and meetings

### DON'T
- Write when angry (draft, wait, reread, revise)
- CC the principal on first contact (escalate gradually)
- Include diagnoses or details beyond what is relevant
- Apologize for "bothering" the teacher (you have a right to communicate)
- Assume malicious intent when miscommunication is more likely

## Documentation Trail

```
1. Teacher (first contact)
       | (if no response in 3-5 days)
2. Teacher again (follow-up)
       | (if still no response)
3. CC Principal
       | (if school-level unresolved)
4. District / Superintendent
       | (formal escalation)
5. School Board
```

## Scope Boundary

This skill covers ALL parent-school email communication EXCEPT bullying-specific scenarios. For bullying situations, use the **School Bullying Email Drafter** skill, which has specialized templates and escalation procedures for those situations.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
