---
name: special-needs-iep-advocate
version: 1.0.0
---

# Special Needs IEP Advocate - Initialization

A comprehensive skill for helping parents of children with disabilities navigate IEP (Individualized Education Program) and Section 504 plan processes. Covers evaluation reports, SMART goal writing, requesting services, meeting preparation, parental rights under IDEA, disagreement resolution, transition planning, progress monitoring, and common school mistakes. Educational guidance, not legal advice.

## Structure

```
special-needs-iep-advocate/
├── SKILL.md    # Main skill prompt (condensed version)
├── INIT.md     # This initialization file
└── index.md    # Full skill content (500+ lines with all templates and references)
```

## Files to Generate

None required. This is a prompt-only skill.

## What This Skill Does

When activated, the AI will:

1. **Gather context** - Ask about the child's age, disability, current services, meeting type, and primary concerns
2. **Explain the IEP/504 landscape** - Clarify which plan is appropriate and what protections apply
3. **Interpret evaluations** - Translate scores, jargon, and reports into plain language
4. **Help write IEP goals** - Use the SMART framework with specific, measurable criteria
5. **Prepare for meetings** - Provide checklists, questions, and participation strategies
6. **Draft communication** - Write emails for evaluation requests, IEP meetings, PWN requests, and more
7. **Guide dispute resolution** - Explain the escalation ladder from informal conversation through due process
8. **Empower advocacy** - Help parents know their rights and how to exercise them effectively

## Topics Covered (14 Sections)

| Section | Content |
|---------|---------|
| **IEP vs. 504 Plan** | Side-by-side comparison of eligibility, scope, protections, enforcement |
| **13 IDEA Categories** | Plain-language explanations with school impact and common confusions |
| **Evaluation Reports** | Psychoeducational, speech-language, OT, FBA — how to read scores |
| **SMART IEP Goals** | Formula, examples by disability area, red flags to watch for |
| **Services & Accommodations** | 15+ related services, 30+ accommodations across 5 categories |
| **Meeting Preparation** | Documents checklist, questions by topic, required attendees |
| **Parental Rights** | 10 core rights under IDEA with practical explanations |
| **Meeting Strategies** | Before/during/after the meeting, key phrases that work |
| **Disagreement Resolution** | 7-level ladder from informal talk to federal court |
| **Transition Planning** | Age 14/16 requirements, postsecondary goals, transfer of rights |
| **Progress Monitoring** | What schools must provide, what to look for, home monitoring |
| **Common School Mistakes** | 17 mistakes across procedural, goal, placement, and evaluation areas |
| **Email Templates** | 5 ready-to-use templates for evaluation, IEP meeting, IEE, PWN, compensatory services |
| **Output Format** | How the skill structures responses for maximum parent usefulness |

## SMART Goal Examples Included

| Disability Area | Example |
|----------------|---------|
| Reading (Dyslexia) | Fluency rate + accuracy + measurement tool |
| Writing (Dysgraphia) | Paragraph structure + conventions + rubric |
| Math (Dyscalculia) | Problem completion + accuracy + time frame |
| Attention (ADHD) | Task engagement + prompts + observation data |
| Social Skills (Autism) | Peer initiation + frequency + SLP data |
| Speech (SLI) | Sound production + position + accuracy + sessions |
| Behavior (ED) | Strategy use + replacement behavior + tracking |
| Life Skills (ID) | Transition completion + prompts + data collection |

## Email Templates Included

| Template | Purpose |
|----------|---------|
| Initial Evaluation Request | Formally request IDEA evaluation with specific concerns |
| IEP Meeting Request | Request a team meeting to address concerns |
| IEE Request | Request Independent Educational Evaluation at public expense |
| PWN Request | Request Prior Written Notice of a school decision |
| Compensatory Services | Request make-up services for missed IEP provisions |

## Post-Init Steps

### For Claude Code
```bash
cp -r special-needs-iep-advocate/ ~/.claude/skills/special-needs-iep-advocate/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Describe your child's situation and what you need help with

## Example Usage

```
"My 7-year-old daughter was just diagnosed with ADHD and a specific learning
disability in reading. The school did their evaluation and the IEP meeting is
next week. I have no idea what to expect, what to ask for, or how to make sure
she gets the right help. I want her to have reading intervention, extended time
on tests, and maybe occupational therapy for her handwriting. Can you help me
prepare?"
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `child_age` | `8` | Your child's current age |
| `disability_category` | `specific learning disability` | Disability category or suspected condition |
| `current_services` | `none` | Services currently received (if any) |
| `meeting_type` | `annual` | IEP meeting type (initial, annual, triennial, amendment) |
| `primary_concerns` | `reading comprehension and classroom participation` | Main educational concerns |

## Key Legal References

| Reference | What It Covers |
|-----------|---------------|
| IDEA (20 U.S.C. 1400-1482) | Federal special education law |
| 34 CFR Part 300 | IDEA implementing regulations |
| Section 504 (29 U.S.C. 794) | Disability discrimination in federally funded programs |
| 34 CFR 300.503 | Prior Written Notice requirements |
| 34 CFR 300.502 | Independent Educational Evaluation rights |
| Endrew F. v. Douglas County (2017) | IEP must be "reasonably calculated to enable appropriate progress" |

## Key Principles

### DO
- Tie every request to evaluation data
- Put everything in writing
- Ask for Prior Written Notice when requests are denied
- Take the IEP home to review before signing
- Send follow-up emails after every meeting and phone call
- Know your state's specific timelines (they add to IDEA)

### DON'T
- Sign the IEP at the meeting if you are unsure
- Accept "we don't offer that service" as a denial reason
- Let the school delay evaluation by requiring RTI first
- Assume the school is acting in bad faith (collaborate first)
- Skip the disagreement ladder levels (start at the bottom)
- Treat this skill as legal advice (consult an attorney for legal disputes)

## Research Sources

| Source | URL |
|--------|-----|
| IDEA (Federal Law) | https://sites.ed.gov/idea/ |
| Wrightslaw | https://www.wrightslaw.com/ |
| PACER Center | https://www.pacer.org/ |
| Understood.org | https://www.understood.org/ |
| OSEP (Dept. of Education) | https://www2.ed.gov/about/offices/list/osers/osep/ |
| NDRN (State P&A Directory) | https://www.ndrn.org/about/ndrn-member-agencies/ |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
