---
name: teen-conversation-starter
version: 1.0.0
---

# Initialization

Teen Conversation Starter - Provides age-appropriate discussion prompts and conversation frameworks for parents to connect with teenagers on tough topics including mental health, substance use, relationships, social media, body image, identity, academic pressure, money/independence, and family changes. Adapts scripts by age group (13-14, 15-16, 17-18), relationship quality, and conversation setting.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with conversation frameworks, topic guides, and scenario scripts

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r teen-conversation-starter/ ~/.claude/skills/teen-conversation-starter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{teen_age}}` | `15` | Teenager's age (13-18) for age-appropriate language and topic depth |
| `{{topic_category}}` | `general check-in` | Topic area: mental-health, substance-use, relationships, social-media, body-image, identity, academic-pressure, money-independence, family-changes |
| `{{relationship_quality}}` | `close` | Current parent-teen relationship status (close, strained, rebuilding) |
| `{{conversation_setting}}` | `casual` | Where you plan to talk: car-ride, dinner, walk, bedtime, planned-sit-down |
| `{{parent_concern}}` | `` | Specific worry or behavior noticed (optional) |

## Core Capabilities

1. **Foundational Conversation Principles** - Five rules of talking to teens: listen first, no lectures, validate feelings, timing matters, repair is everything
2. **Topic-Specific Guides** - Nine detailed topic areas with age-adapted conversation openers and follow-up scripts:
   - Mental health (anxiety, depression, self-harm, therapy stigma)
   - Substance use (alcohol, drugs, vaping, peer pressure)
   - Relationships (dating, consent, heartbreak, healthy vs. unhealthy)
   - Social media (cyberbullying, comparison, screen time, online safety)
   - Body image (diet culture, exercise, puberty, eating disorders)
   - Identity (sexual orientation, gender identity, values, faith)
   - Academic pressure (grades, college, career, burnout)
   - Money and independence (first job, budgeting, driving)
   - Family changes (divorce, moving, loss, blended families)
3. **Setting-Specific Starters** - Conversation openers tailored to car rides, dinner, walks, and bedtime
4. **HEAR Active Listening Method** - Halt, Empathize, Ask, Reflect framework adapted for teens
5. **Shutdown Re-Engagement** - Five strategies when teens stop communicating: low-pressure, written, indirect, activity bridge, third-party
6. **Red Flag Recognition** - Three-tier system for identifying when professional help is needed (immediate, urgent, monitor)
7. **Scenario Scripts** - Ready-to-use scripts for "I found something," "teacher called," "you seem sad," and more
8. **Age Adaptations** - Developmental context and approach adjustments for early (13-14), middle (15-16), and late (17-18) adolescence
9. **Cultural Sensitivity** - Guidance for collectivist cultures, authority structures, faith-based families, immigrant families, and single-parent households

## Research Foundation

- CDC Adolescent and School Health data on teen mental health trends
- APA Developing Adolescents reference for communication strategies
- SAMHSA "Talk. They Hear You" evidence-based conversation guides
- Steinberg's Age of Opportunity adolescent brain development research
- NIMH Teen Brain neuroscience findings

## Example Usage

"My 15-year-old daughter has been withdrawn for two weeks. She used to talk about school and friends but now barely makes eye contact. Our relationship is strained. Help me start a conversation about what's going on."

"My 14-year-old son started high school and I'm worried about peer pressure with vaping. How do I bring it up without sounding preachy?"

"I found alcohol in my 16-year-old's backpack. What do I say?"

## Disambiguation

This skill is different from **Teen Text Decoder** (which decodes Gen Z slang and text abbreviations). Teen Conversation Starter helps parents *initiate and navigate* meaningful conversations on tough topics, rather than interpreting digital communication.
