---
name: toddler-meal-ideas-generator
version: 1.0.0
---

# Toddler Meal Ideas Generator - Initialization

Generate creative, nutritious meal ideas for picky toddlers ages 1-5 with allergen awareness, fun presentation, and evidence-based feeding strategies.

## What This Skill Does

This skill transforms your AI assistant into a pediatric nutrition advisor who creates:

- **80+ meal ideas** across breakfast, lunch, dinner, and snacks tailored to your child's age and preferences
- **Picky eater strategies** including food bridges, repeated exposure, deconstructed meals, and fun food presentation
- **Nutrition guidance** covering iron, calcium, zinc, omega-3s, and age-specific portion sizes for children 1-5
- **Allergen management** with introduction protocols based on the LEAP study and Big 9 allergen safety
- **Texture progression plans** from purees through table foods with red flags for professional referral
- **Batch cooking guides** with a 2-hour Sunday prep session and freezer-friendly meal plans
- **Hidden nutrition techniques** for veggie-loaded sauces, smoothie boosters, and invisible vegetables
- **Ellyn Satter Division of Responsibility** framework for reducing mealtime stress

## Package Structure

```
toddler-meal-ideas-generator/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r toddler-meal-ideas-generator/ ~/.claude/skills/toddler-meal-ideas-generator/
```

Then reference in your conversation:
```
Use the toddler-meal-ideas-generator skill to help me plan meals for my toddler.
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a Custom Instruction or at the start of your conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter
3. Paste into your AI assistant as context or system prompt

## Variables

Customize the skill by mentioning these in your prompt:

| Variable | Default | Description |
|----------|---------|-------------|
| `child_age` | `2 years` | Age of the child (12 months to 5 years). Determines texture, portion sizes, and food safety recommendations. |
| `known_allergies` | `none` | Confirmed or suspected food allergies (Big 9: milk, eggs, peanuts, tree nuts, wheat, soy, fish, shellfish, sesame) |
| `foods_child_likes` | `bananas, pasta, cheese, chicken nuggets, crackers` | Foods the child currently accepts. Used to create food bridges to new flavors. |
| `meal_type` | `all` | Which meal to generate ideas for: `breakfast`, `lunch`, `dinner`, `snack`, or `all` |
| `dietary_restrictions` | `none` | Family dietary needs: `vegetarian`, `vegan`, `halal`, `kosher`, `dairy-free`, `gluten-free`, etc. |

## Example Usage

### Basic Meal Ideas for a Picky Toddler
```
My 2-year-old only eats bananas, yogurt, pasta, and cheese. She refuses all vegetables.
Can you give me a week of lunch ideas that might work for her? No food allergies.
```

### Allergen-Aware Meal Planning
```
My 14-month-old has a confirmed egg allergy and we suspect dairy sensitivity.
I need breakfast and snack ideas that are egg-free and dairy-free.
She currently likes avocado, sweet potato, and rice.
```

### Texture Progression Help
```
My 18-month-old still only eats purees and gags on anything with chunks.
I need help transitioning him to soft finger foods. He likes sweet potato puree,
yogurt, and applesauce. No allergies.
```

### Vegetarian Toddler Nutrition
```
We are a vegetarian family. My 3-year-old is a typical picky eater.
I'm worried about iron and protein. Can you give me dinner ideas
that are high in iron and protein without meat? He likes pasta, beans, and cheese.
```

### Batch Cooking for Busy Parents
```
I work full-time and need to meal prep on Sunday for my 2.5-year-old's daycare lunches.
She eats chicken, rice, most fruits, and some vegetables. Peanut allergy.
Give me 5 freezer-friendly meals I can make in 2 hours.
```

### Food Refusal and Mealtime Battles
```
My 4-year-old throws a tantrum at every dinner if it's not chicken nuggets or pizza.
He used to eat more variety but has gotten pickier over the past year.
I need strategies and meal ideas to expand his diet without making mealtimes a war zone.
```

## Key Concepts

- **Division of Responsibility**: Parents decide what, when, and where; children decide whether and how much
- **Food bridges**: Connect accepted foods to new foods through shared characteristics
- **15-30 exposures**: A child may need to see a food 15-30 times before accepting it
- **Safe food rule**: Always include one accepted food at every meal
- **Iron priority**: Most common toddler deficiency; limit milk to 16-24oz/day
- **Portion size rule**: One tablespoon per food per year of age
- **No pressure**: Forcing, bribing, and "just one bite" all backfire long-term
- **Patterns over meals**: Nutrition balances over a week, not a single meal

## Evidence Base

This skill integrates:
- AAP (American Academy of Pediatrics) pediatric nutrition guidelines
- Ellyn Satter Division of Responsibility in Feeding framework
- WHO (World Health Organization) complementary feeding guidance
- NIAID/LEAP study allergen introduction protocols
- AAP clinical reports on iron deficiency in toddlers

## Disclaimer

This skill provides general nutrition information and meal ideas for typically developing children. It is not medical nutrition therapy and does not replace professional guidance. Consult your pediatrician or a registered pediatric dietitian for children with diagnosed feeding disorders, failure to thrive, multiple severe food allergies, or any concerns about growth and nutritional status.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
