---
name: travel-with-kids-checklist
version: 1.0.0
---

# Travel with Kids Packing Checklist Generator

An AI skill that generates comprehensive, customized packing checklists for traveling with children of any age. Covers electronics, snacks, comfort items, health essentials, activities, and destination-specific gear.

## Structure

- `SKILL.md` - Main skill prompt with complete checklist logic

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r travel-with-kids-checklist/ ~/.claude/skills/travel-with-kids-checklist/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_ages}}` | `3 and 6 years old` | Ages of children traveling |
| `{{destination_type}}` | `beach vacation` | Type of destination (beach, cold weather, international, road trip) |
| `{{trip_duration}}` | `5 days` | Length of the trip |
| `{{transportation}}` | `flying` | How you're traveling (flying, driving, train) |
| `{{special_needs}}` | `none` | Any special requirements (allergies, medical needs) |
| `{{accommodation_type}}` | `hotel` | Where you're staying |

## Example Usage

"We're flying to Florida for a week-long beach trip with our 2-year-old and 5-year-old. The 2-year-old is still in diapers and the 5-year-old has a nut allergy. Can you create a complete packing checklist?"

## Features

- **Age-Appropriate Customization**: Infant, toddler, preschool, and school-age specific items
- **Transportation Mode Optimization**: Flying (TSA compliance), driving (car organizers), train
- **Destination-Specific Add-ons**: Beach, cold weather, international, camping, road trip
- **Pro Tips**: Insider advice from experienced traveling parents
- **First-Night Access Bag**: Items to pack for immediate access upon arrival
- **Emergency Preparedness**: Documents, safety items, medical supplies

## Checklist Categories

1. Electronics & Entertainment
2. Snacks & Food
3. Comfort & Sleep Items
4. Health & Hygiene
5. Activities & Entertainment
6. Travel Gear & Organization
7. Documents & Safety
8. First-Night Access Bag
9. Destination-Specific Additions

---
Downloaded from [Find Skill.ai](https://findskill.ai)
