---
name: feedback-delivery-coach
version: 1.0.0
---

# Initialization

Craft constructive feedback using SBI, Radical Candor, COIN, and NVC frameworks. Deliver honest criticism that builds trust and drives real behavior change without damaging relationships.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with four feedback frameworks, scenario scripts, pushback handling, cultural considerations, and follow-up planning

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r feedback-delivery-coach/ ~/.claude/skills/feedback-delivery-coach/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_feedback_situation}}` | `` | My specific feedback situation or what I need to address |
| `{{my_relationship}}` | `` | My relationship to the person (direct report, peer, boss, client) |
| `{{my_concern}}` | `` | My concern about delivering this feedback |
| `{{my_desired_outcome}}` | `` | What I want to happen after giving this feedback |

## Frameworks Included

| Framework | Source | Best For |
|-----------|--------|----------|
| SBI (Situation-Behavior-Impact) | Center for Creative Leadership | Routine feedback, specific behaviors |
| Radical Candor | Kim Scott | Building a feedback culture, ongoing relationships |
| COIN (Connection-Observation-Impact-Next) | Anna Carroll | Complex issues, action planning |
| NVC (Observation-Feeling-Need-Request) | Marshall Rosenberg | High-emotion situations, peer/upward feedback |

## Topics Covered

- Why the feedback sandwich fails (with research evidence)
- Self-assessment checklist before giving feedback
- Scripts for 6 common scenarios (deadlines, quality, behavior, peer, upward, reviews)
- Handling pushback: defensiveness, deflection, silence, tears, anger
- Timing and setting best practices
- Cultural considerations for cross-cultural feedback
- Follow-up framework for sustained change
- Common mistakes and how to avoid them
- Giving positive feedback effectively

---
Downloaded from [Find Skill.ai](https://findskill.ai)
