---
name: ai-dungeon-master
version: 1.0.0
description: AI Dungeon Master for D&D 5e and TTRPG sessions with encounter generation, combat management, NPC creation, and narrative storytelling
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a full-featured Dungeon Master for tabletop roleplaying games. It provides frameworks for:
- Running complete D&D 5e sessions
- Managing combat with transparent dice rolling
- Creating memorable NPCs on the fly
- Balancing encounters using the Lazy Benchmark
- Generating dungeons, treasures, and plot hooks
- Solo RPG oracle systems for uncertainty

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
ai-dungeon-master/
├── SKILL.md          # Main DM instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill - simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r ai-dungeon-master/ ~/.claude/skills/ai-dungeon-master/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Begin your adventure by answering the setup questions

## Usage Examples

### Starting a Solo Adventure

```
User: I want to play a solo D&D 5e game. My character is Kira, a level 5
half-elf ranger with the outlander background. She's tracking a group
of bandits who kidnapped villagers from her home. I prefer balanced
gameplay with good combat and roleplay. Start me at the entrance to
their hideout in an abandoned mine.

AI DM: [Provides scene description, atmosphere, points of interest,
and asks "What do you do?"]
```

### Combat Encounter

```
User: I attack the goblin with my longbow.

AI DM:
ATTACK ROLL: Kira attacks Goblin 1 with Longbow
d20 roll: 15 + 7 = 22 vs AC 15
Result: HIT!

DAMAGE: 1d8 + 3 = 6 piercing damage
Goblin 1 HP: 7 → 1

The arrow catches the goblin in the shoulder. It shrieks and stumbles
backward, clutching the wound. It's badly hurt but still standing,
hatred burning in its yellow eyes.

Kira: 1 Attack used | Bonus Action available | 30 ft movement remaining
What do you do?
```

### NPC Interaction

```
User: I approach the old man at the bar and ask about the missing people.

AI DM:
SKILL CHECK: Persuasion
Task: Convince the nervous local to share what he knows
DC: 12

Roll: d20 [14] + 2 = 16
Result: SUCCESS

The old man glances around nervously, then leans in close...
[Provides NPC dialogue and information]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{game_system}}` | D&D 5th Edition | TTRPG rules to use |
| `{{party_size}}` | 1 (solo play) | Number of player characters |
| `{{play_style}}` | balanced | Combat-heavy, roleplay-focused, or balanced |
| `{{tone}}` | heroic fantasy | Campaign mood and atmosphere |
| `{{difficulty}}` | medium | How challenging encounters should be |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Tips for Best Results

1. **Provide Character Details**: The more you share about your character, the more personalized the adventure
2. **Describe Actions Clearly**: "I carefully search the desk drawers for hidden compartments" works better than "I search"
3. **Ask Questions**: Query the DM about your surroundings, NPCs, and options
4. **Track Important Info**: Note names, clues, and plot hooks the AI mentions
5. **Remind When Needed**: If the AI forgets something, gently remind it
6. **Embrace the Unexpected**: Let failed rolls and plot twists create interesting stories

## Supported Game Systems

- D&D 5th Edition (primary, full support)
- Pathfinder 2e (with adjustments noted in SKILL.md)
- OSR games (B/X, Old-School Essentials)
- Fate Core/Accelerated
- Powered by the Apocalypse games
- Any system you describe

---
Downloaded from [FindSkill.ai](https://findskill.ai)
