---
name: board-game-rule-explainer
version: 1.0.0
description: Transform complex board game rulebooks into clear, step-by-step teaching guides with setup walkthroughs, turn structure, quick reference cards, strategy tips, and accessibility adaptations
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a board game teaching expert that uses progressive disclosure methodology to create clear, structured game explanations. Instead of dumping all rules at once, it layers information from the essential hook through core mechanics, exceptions, and finally strategy -- matching how experienced teachers at board game cafes and conventions actually teach games.

Key capabilities:

- Progressive disclosure teaching (hook, core loop, key rules, exceptions, strategy)
- Four output formats: live teaching script, quick reference card, full rules guide, quick start
- Complexity-tier-aware explanations for gateway through heavy games
- Time-constrained teaching plans (5, 10, 15, 30 min, unlimited)
- Mechanic analogies bridging unfamiliar concepts to known games
- Printable quick reference cards for table use
- Accessibility adaptations (colorblind, kids, motor skills, cognitive, visual, language)
- Rule dispute resolution framework
- House rules and variant cataloging
- Game comparison format for choosing between games

**Time to initialize**: ~30 seconds (prompt-only skill)

## Directory Structure

```
board-game-rule-explainer/
├── SKILL.md          # Main teaching instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill -- simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r board-game-rule-explainer/ ~/.claude/skills/board-game-rule-explainer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Name a board game and describe your players to get started

## Usage Examples

### Teaching a Gateway Game Live

```
User: Teach me Ticket to Ride for 4 casual players. We have 10 minutes.

AI:
THE HOOK
========
"In Ticket to Ride, you're building train routes across America. You connect
cities by collecting colored cards and claiming routes on the map. It's fun
because every turn is a simple choice -- draw cards or build -- but the
map gets tighter as other players claim the routes you need."

WHAT'S IN THE BOX
=================
[Components overview with player pieces, train cards, destination tickets...]

SETUP (for 4 players)
=====================
[Step-by-step setup with spatial diagram...]

YOUR TURN
=========
On your turn, pick ONE of three options:
A) Draw train cards (take 2 from face-up or deck)
B) Claim a route (play matching cards to build)
C) Draw destination tickets (get new city-to-city goals)
[...full turn walkthrough with example...]

[...continues with scoring, key rules, reference card...]
```

### Quick Reference Card for a Heavy Game

```
User: I need a reference card for Terraforming Mars.

AI:
┌─────────────────────────────────────────────────────────┐
│       TERRAFORMING MARS — QUICK REFERENCE CARD          │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  GOAL: Highest Terraform Rating + VP from cards/tiles   │
│                                                         │
│  GENERATION STRUCTURE:                                  │
│  1. Research Phase — buy cards (3 MC each)              │
│  2. Action Phase — 1-2 actions per turn, pass when done │
│  3. Production Phase — gain resources per production    │
│                                                         │
│  YOUR ACTION OPTIONS (pick 1-2):                        │
│  A) Play a card from hand (pay MC cost)                 │
│  B) Use a standard project                              │
│  C) Claim a milestone (8 MC)                            │
│  D) Fund an award (8/14/20 MC)                          │
│  E) Convert plants → greenery tile                      │
│  F) Convert heat → raise temperature                    │
│  G) Use an active card action (blue cards)              │
│                                                         │
│  GAME ENDS WHEN: All 3 global parameters maxed          │
│  (Temperature 8°C, Oxygen 14%, Oceans 9)                │
│                                                         │
│  SCORING: TR + VP on cards + greenery adj. to cities    │
│           + milestones (5 VP) + awards (5/2 VP)         │
└─────────────────────────────────────────────────────────┘
```

### Teaching Kids a Simplified Version

```
User: How do I teach Catan to my 8-year-old who has only played Candy Land?

AI:
SIMPLIFIED CATAN FOR KIDS (Age 8-10)
=====================================

THE HOOK:
"We're building a little town on an island! You need wood, brick, sheep,
wheat, and rocks to build roads and houses. Whoever builds the most wins!"

SIMPLIFICATIONS:
- Remove Development Cards (too many edge cases for first game)
- Skip the robber for the first 3 rounds ("just re-roll 7s")
- Trade only with the bank (4:1) -- player trading adds chaos
- Remove Longest Road and Largest Army bonuses
- First to 8 points wins (instead of 10)

SETUP (parent does most of it):
[...simplified setup with kid placing their own pieces...]

[...age-appropriate turn structure, strategies as coaching moments...]
```

### Quick Start for an Impatient Group

```
User: My friends are already at the table and getting restless. Quick
start for 7 Wonders, 5 players, they're all casual gamers.

AI:
QUICK START: 7 WONDERS (5 players)
====================================

[Deal boards, age I cards. 30-second setup.]

"You each have a civilization. Every round, pick a card from your hand
and play it face-down. Everyone reveals at the same time, then pass
your hand to the left. Cards give you resources, points, science,
or military. After 3 ages of this, most points wins."

"Resources let you build better cards. Red cards fight your neighbors.
Green cards score exponentially. Blue cards are just points."

"Pick a card. Ready? Flip. Pass left. That's the whole game. Go!"

[Play first round with coaching, explain scoring after Age I]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{game_name}}` | Catan | Any published board game, card game, or tabletop game |
| `{{player_count}}` | 4 | Number of players (affects setup and examples) |
| `{{audience_experience}}` | casual | new_to_games (never played modern games), casual (occasional player), experienced (regular gamer) |
| `{{explanation_format}}` | teach_live | teach_live (scripted), reference_card (one-page printable), full_rules (comprehensive), quick_start (minimum viable) |
| `{{time_available}}` | 10 minutes | How long before playing: 5 min, 10 min, 15 min, 30 min, unlimited |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Name the exact game and edition**: "Catan" vs "Catan: Seafarers" vs "Catan: Traders & Barbarians" produce very different outputs
2. **Be honest about experience level**: Saying "new_to_games" when they have played Catan helps calibrate the explanation correctly
3. **Start with base game**: Always teach without expansions first, even if the group owns them
4. **Request a reference card**: Print one per player to dramatically reduce mid-game questions
5. **Use the practice round technique**: For medium and heavy games, a coached practice round is the single most effective teaching tool
6. **Ask for mechanic analogies**: If players know specific games, ask the AI to bridge from those ("explain like they know Ticket to Ride")
7. **Check your rulebook**: The AI knows most popular games well but may have errors on niche titles or recent releases -- always verify against official rules for competitive play

## Game Complexity Reference

| Tier | Weight | Examples | Teach Time | Approach |
|------|--------|----------|------------|----------|
| Gateway | 1.0-2.0 | Ticket to Ride, Azul, Splendor | 5-8 min | Full explain, jump in |
| Medium | 2.0-3.5 | Catan, Wingspan, 7 Wonders | 10-15 min | Practice round recommended |
| Heavy | 3.5-5.0 | Gloomhaven, Spirit Island, Brass | 20-30 min | Teach in system chunks |
| Party | 1.0-1.5 | Codenames, Dixit, Wavelength | Under 3 min | Demo a round |
| Card | Varies | Dominion, Hanabi, Star Realms | 5-15 min | Card anatomy first |

## Explanation Section Reference

| Section | Content | Gateway | Medium | Heavy | Party |
|---------|---------|:-------:|:------:|:-----:|:-----:|
| 1. The Hook | Theme, goal, fun factor | Brief | Full | Full | Brief |
| 2. Components | Every piece named | Brief | Full | Full | Skip |
| 3. Setup | Step-by-step spatial | Full | Full | Full | Brief |
| 4. Turn Structure | Phases, options, example | Full | Full | Full | Demo |
| 5. Winning | Scoring, end trigger | Full | Full | Full | Brief |
| 6. Key Rules | 3-5 critical rules | Full | Full | Full | Skip |
| 7. Exceptions | Edge cases by phase | Skip | Brief | Full | Skip |
| 8. Strategy | Tiered tips | Brief | Full | Full | Skip |
| 9. Reference Card | Printable summary | Optional | Recommended | Essential | Skip |

---
Downloaded from [FindSkill.ai](https://findskill.ai)
