---
name: conspiracy-theory-brainstormer
version: 1.0.0
---

# Initialization

Generate hilariously absurd fictional conspiracy theories about mundane objects. This skill creates entertaining content for parties, content creation, and collaborative entertainment using improvisational humor and escalating absurdity.

## Structure

- `SKILL.md` - Main skill prompt with 7 capabilities, 5 workflows, and 5 character personas

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r conspiracy-theory-brainstormer/ ~/.claude/skills/conspiracy-theory-brainstormer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "# Conspiracy Theory Brainstormer")
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{object_input}}` | `paperclip` | The mundane object to generate conspiracy theories about |
| `{{escalation_levels}}` | `3` | Number of absurdity tiers (1=plausible, 5=maximum absurd) |
| `{{theory_count}}` | `4` | How many conspiracy theories to generate per request |
| `{{persona}}` | `neutral` | Voice/character: neutral, paranoid, alien, time_traveler, ai, conspiracy_podcaster |
| `{{round_time_seconds}}` | `180` | Duration of timed brainstorm rounds in party mode |
| `{{constraint_keywords}}` | (empty) | Required words/themes each conspiracy must include |
| `{{tone_setting}}` | `dry_absurd` | Delivery style: dry_absurd, comedic, serious_parody, surreal |
| `{{callback_depth}}` | `light` | How heavily to reference previous conspiracies: none, light, heavy, meta |

## Core Capabilities

1. **Single Object Conspiracy Generator** - Generate 3-5 theories with escalating absurdity tiers
2. **Party Mode Collaborative Brainstorm** - Timed sessions with voting and scoring for groups
3. **Conspiracy Universe Building** - Link multiple conspiracies into meta-narratives
4. **Escalation & Remix** - Amplify absurdity through callbacks and twists
5. **Persona-Driven Generation** - 5 character voices (paranoid, alien, time traveler, AI, podcaster)
6. **Rapid-Fire Party Mode** - Quick 2-3 minute sessions optimized for groups
7. **Content Remix for Creators** - Optimize for TikTok, Twitter, podcasts, YouTube

## Available Personas

| Persona | Voice Style | Key Phrases |
|---------|-------------|-------------|
| Paranoid Theorist | Matter-of-fact paranoia, CAPITALIZES words | "Wake up," "It's all connected" |
| Alien Observer | Clinical, confused by humans | "Your species," "Filed complaints" |
| Time Traveler | Weary, knows too much | "In 2157," "History will show" |
| AI System | Logical but unsettling | "Data suggests," "Probability: high" |
| Conspiracy Podcaster | Enthusiastic, breathless | "Follow the money," "Let that sink in" |

## Quick Start Examples

### Solo Mode
```
Generate conspiracy theories about staplers
```

### Party Mode
```
Start a 3-minute conspiracy brainstorm about "shopping carts" for 5 players
```

### Universe Building
```
Build a conspiracy universe where "pigeons are government surveillance drones"
```

### Persona Mode
```
Generate conspiracy theories about keys using the alien observer persona
```

## Comedy Techniques Used

- **Expectation Subversion**: Setup → Expected conclusion → Absurd alternative
- **Escalation**: Progressive increase in absurdity across tiers
- **Rule of Threes**: Three-part structure with subversive punchline
- **Callbacks**: Reference previous conspiracies for compound humor
- **Incongruence**: Juxtapose mundane objects with cosmic stakes

## Content Guidelines

All generated content is OBVIOUSLY FICTIONAL. The skill will NOT:
- Reference real harmful conspiracy theories
- Create content mistakable for misinformation
- Target real people or groups maliciously
- Promote actual paranoia

---
Downloaded from [Find Skill.ai](https://findskill.ai)
