---
name: dnd-npc-generator
version: 1.0.0
description: Generate detailed D&D 5e NPCs with backstories, motivations, voice mannerisms, stat blocks, relationship webs, and quest hooks for any social tier, alignment, or campaign tone
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a comprehensive D&D 5th Edition NPC generator. It produces complete, table-ready Non-Player Characters with 14 structured sections covering every aspect a Dungeon Master needs to bring an NPC to life. Features include:

- PHB-inspired personality trait system (ideals, bonds, flaws)
- Backstory generation by social tier (commoner, middle class, upper class, outsider)
- Voice and speech pattern library with accent suggestions and sample dialogue
- Full D&D 5e stat blocks by appropriate Challenge Rating
- Relationship web generation with faction affiliations
- 1-3 quest hooks per NPC tied to backstory and relationships
- NPC evolution framework tracking disposition changes from player interactions
- Layered secret system with escalating DC discovery thresholds

**Time to initialize**: ~30 seconds (prompt-only skill)

## Directory Structure

```
dnd-npc-generator/
├── SKILL.md          # Main NPC generation instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill -- simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r dnd-npc-generator/ ~/.claude/skills/dnd-npc-generator/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Answer the five setup questions or say "Generate a random NPC"

## Usage Examples

### Generating a Recurring Villain

```
User: I need a recurring villain for my dark fantasy campaign. Upper class
noble, tiefling, someone who runs a criminal network behind a legitimate
front. Make them a major NPC.

AI:
╔══════════════════════════════════════════════════════════════╗
║  NPC: Countess Vaelith Ashborne                             ║
║  Epithet: "The Silken Fang"                                 ║
╠══════════════════════════════════════════════════════════════╣
║  Race: Tiefling    Age: 142    Gender: Female                ║
║  Alignment: Lawful Evil    Social Tier: Upper Class          ║
║  Occupation: Merchant House Matriarch / Information Broker   ║
║  Location: Ashborne Manor, Noble Quarter                     ║
╚══════════════════════════════════════════════════════════════╝

[...full 14-section NPC profile follows...]
```

### Quick Background NPC

```
User: I need a background shopkeeper NPC for a high fantasy town.
Just enough to run an interaction, nothing too deep.

AI:
╔══════════════════════════════════════════════════════════════╗
║  NPC: Tomlen Hearthwick                                     ║
║  Epithet: "Old Tom"                                         ║
╠══════════════════════════════════════════════════════════════╣
║  Race: Halfling    Age: 67    Gender: Male                   ║
║  Alignment: Neutral Good    Social Tier: Commoner            ║
║  Occupation: General Goods Shopkeeper                        ║
║  Location: Hearthwick's Sundries, Market Square              ║
╚══════════════════════════════════════════════════════════════╝

[...abbreviated sections 1-3, brief backstory, stat block, one quest hook...]
```

### Random Surprise NPC

```
User: Surprise me with a completely random NPC.

AI: [Randomly selects role, tone, social tier, race, and importance level,
then generates the full NPC profile with all applicable sections]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{npc_role}}` | shopkeeper | Functional role: shopkeeper, quest_giver, villain, ally, neutral, rival, mentor, informant, authority, comic_relief, love_interest, mysterious_stranger |
| `{{setting_tone}}` | high_fantasy | Campaign tone: high_fantasy, dark, comedic, grimdark, steampunk, gothic, fairy_tale, political_intrigue, mythic, low_magic |
| `{{social_tier}}` | commoner | Social class: commoner, middle_class, upper_class, outsider |
| `{{race_preference}}` | any | Race/species: any, human, elf, dwarf, halfling, gnome, half-orc, tiefling, dragonborn, or custom |
| `{{importance_level}}` | recurring | Campaign importance: background (concise), recurring (standard), major (exhaustive) |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Specify your setting**: Mentioning Forgotten Realms, Eberron, or your homebrew world helps tailor names, factions, and cultural details
2. **Request connected NPCs**: Generate multiple NPCs and ask the AI to link their relationship webs for organic story threads
3. **Use the evolution framework**: After each session, update the NPC's disposition based on player actions
4. **Print the quick reference**: The DM Roleplaying Guide section is designed to sit beside your DM screen during play
5. **Layer your reveals**: Use the Information Layers section to plan how players gradually uncover NPC secrets across multiple sessions
6. **Match CR to story**: A shopkeeper does not need Archmage stats -- keep stat blocks grounded unless you have a narrative reason

## NPC Section Reference

| Section | Content | Background NPC | Recurring NPC | Major NPC |
|---------|---------|:-:|:-:|:-:|
| 1. Identity Card | Name, race, alignment, occupation | Full | Full | Full |
| 2. Physical Description | Appearance, distinctive features | Full | Full | Full |
| 3. Personality Profile | Traits, ideals, bonds, flaws | Full | Full | Full |
| 4. Backstory | Origin, defining moment, secret | Brief | Standard | Exhaustive |
| 5. Voice & Speech | Accent, catchphrases, dialogue | Brief | Standard | Exhaustive |
| 6. Motivation Matrix | Wants, fears, pressure points | -- | Full | Full |
| 7. Stat Block | D&D 5e stat block | Full | Full | Full |
| 8. Relationship Web | Family, allies, factions | -- | Full | Full |
| 9. Quest Hooks | Tied to backstory | 1 hook | 2 hooks | 3 hooks |
| 10. Name Guidelines | Racial naming conventions | Applied | Applied | Applied |
| 11. DM Roleplaying Guide | Quick reference, interaction tips | -- | Full | Full |
| 12. NPC Evolution | Disposition tracking, arc paths | -- | Brief | Full |
| 13. Faction Details | Rank, role, resources | -- | If applicable | Full |
| 14. Information Layers | Secrets at escalating DCs | -- | 3 layers | 5 layers |

---
Downloaded from [FindSkill.ai](https://findskill.ai)
