---
name: escape-room-puzzle-designer
version: 1.0.0
description: Design complete escape room experiences with puzzle taxonomy, room flow architecture, narrative integration, difficulty calibration, hint systems, and build guides for professional, DIY home, and virtual settings
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into an expert escape room puzzle designer capable of producing complete, buildable room designs. It covers the full spectrum from professional commercial escape rooms to budget-friendly DIY home experiences and virtual/online adaptations.

Key capabilities:

- Eight-category puzzle taxonomy (logic, search/find, pattern recognition, physical manipulation, codes/ciphers, observation, team coordination, technology)
- Four room flow architectures (linear, open/parallel, multi-linear, sequential with bottlenecks)
- Theme integration framework ensuring puzzles reinforce narrative
- Difficulty calibration with four-phase timing arcs and adjustment levers
- Four hint system models with three-tier progressive hint writing
- DIY home escape room guide with three budget tiers ($0-15, $15-50, $50-150)
- Virtual/online escape room adaptations
- Meta puzzle architecture (combination, assembly, overlay, information, sequence)
- Comprehensive safety requirements and briefing templates
- Testing methodology with cold-tester protocols and iteration frameworks
- Eight ready-to-use theme templates (detective, haunted house, science lab, heist, ancient tomb, space station, pirate, fairy tale)
- Red herring design guidelines with placement rules
- Accessibility considerations (visual, mobility, cognitive, hearing, sensory)
- Complete room design document template (11 sections)
- Reset guides for running multiple groups

**Time to initialize**: ~30 seconds (prompt-only skill)

## Directory Structure

```
escape-room-puzzle-designer/
├── SKILL.md          # Main design instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill -- simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r escape-room-puzzle-designer/ ~/.claude/skills/escape-room-puzzle-designer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Describe your escape room concept to get a complete design

## Usage Examples

### DIY Birthday Party Escape Room

```
User: Design a 45-minute Sherlock Holmes escape room for 6 adults at my house. Budget under $40.

AI:
ROOM OVERVIEW
=============
Theme: "The Blackwood Cipher" -- Victorian detective mystery
Difficulty: Medium (some escape room experience assumed)
Group Size: 6 players
Time Limit: 45 minutes
Setting: Home DIY
Budget: Under $40

NARRATIVE
=========
Lord Blackwood has vanished from his study. Scotland Yard is baffled.
As Baker Street's finest investigators, you have 45 minutes to examine
the evidence, decode the Lord's secret correspondence, and determine
what happened -- before the trail goes cold.

PUZZLE SEQUENCE (Multi-linear flow, 8 puzzles)
===============================================

Puzzle 1: The Evidence Board (Easy, Search/Find)
Narrative: "Examine the detective's evidence board for your first leads."
Setup: Pin index cards with suspect names, locations, and times to a
corkboard. Three cards have letters circled on the back.
Solution: Circled letters spell "DESK" -- directing players to the desk.
Materials: Corkboard ($5), pushpins, index cards, marker
Hints:
  1. "The evidence board has information on both sides."
  2. "Turn over the cards with red pins."
  3. "The circled letters on the backs spell a location in this room."
[...continues with all 8 puzzles, meta puzzle, materials list, setup guide...]
```

### Professional Escape Room Business

```
User: Design a 60-minute space station escape room for a commercial business.
Include technology puzzles with RFID and sensors. Hard difficulty.

AI:
ROOM OVERVIEW
=============
Theme: "Station Omega" -- Deep space emergency
Difficulty: Hard (25-40% escape rate target)
Group Size: 4-6 players
Time Limit: 60 minutes
Setting: Professional (commercial)

NARRATIVE
=========
Station Omega has lost contact with Earth. A cascading systems failure
has locked down the station. As the emergency crew, you must restore
communications, reroute power, and launch the escape pod before life
support fails completely.

PUZZLE SEQUENCE (Multi-linear with bottlenecks, 13 puzzles)
============================================================

Phase 1 -- Diagnostics (Parallel, Easy-Medium)
Puzzle 1: Power Grid Diagnostic (Medium, Technology/Logic)
Narrative: "The power routing console shows a grid of circuits. Reroute
power to the communication array."
Setup: Custom panel with LED-backlit circuit paths. Players toggle
switches to create a complete circuit. Correct path lights green.
Tech: Arduino-controlled LED matrix, 8 toggle switches, solenoid lock
Solution: Specific switch combination creates the complete circuit path
[...continues with full professional-grade design...]
```

### Virtual Team Building Event

```
User: Create a 45-minute virtual escape room for a team of 8 remote
workers. Theme: detective mystery. Using Google Slides and Zoom.

AI:
VIRTUAL ROOM DESIGN
====================
Platform: Google Slides + Zoom breakout rooms
Theme: "The Missing Manuscript" -- A famous author's unpublished novel
has disappeared from the publisher's office.
Group Size: 8 players (split into 2 teams of 4 via breakout rooms)

PUZZLE SEQUENCE
===============

Slide 1: Office Overview (clickable hotspots)
[Interactive image of the publisher's office. Clicking different areas
reveals clue documents, emails, and photographs.]

Puzzle 1: Email Trail (Easy, Observation)
Breakout Room A receives a set of 5 emails. The sender names' first
letters spell "SHELF" -- they must tell Room B to check the bookshelf
hotspot on the main slide.
[...continues with full virtual puzzle design...]
```

### Kids' Birthday Party

```
User: Design a 30-minute pirate treasure hunt escape room for eight
7-year-olds at my house. Keep it simple and under $20.

AI:
ROOM OVERVIEW
=============
Theme: "Captain Goldbeard's Lost Treasure"
Difficulty: Easy (families, young children)
Group Size: 8 kids (ages 6-8)
Time Limit: 30 minutes
Setting: Home DIY (living room)
Budget: Under $20

NARRATIVE
=========
"Ahoy, young pirates! Captain Goldbeard hid his treasure somewhere
in this room before sailing away forever. He left behind a treasure
map -- but it's torn into pieces! Find all the map pieces, solve the
captain's riddles, and discover where X marks the spot!"

PUZZLE SEQUENCE (Linear, 5 puzzles)
=====================================
[...simple, age-appropriate puzzles with treasure map assembly meta...]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{theme}}` | detective mystery | Any narrative concept (detective, haunted house, space station, heist, ancient tomb, pirate, fairy tale, zombie, time travel, spy, etc.) |
| `{{difficulty_level}}` | medium | easy (first-timers/families), medium (some experience), hard (enthusiasts), expert (competitive teams) |
| `{{group_size}}` | 4-6 | Number of players: 2-3, 4-6, 7-8, 8-10 |
| `{{time_limit}}` | 60 | Minutes allotted: 30, 45, 60, 75, 90 |
| `{{setting}}` | home_diy | professional (commercial business), home_diy (party at home), virtual (online/remote), hybrid (physical + digital) |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Start with a strong theme**: The more specific your narrative concept, the more integrated and satisfying the puzzles will be. "Victorian detective investigating a poisoning" produces better results than just "mystery."
2. **Be honest about your audience**: First-timers need easy openers and generous hints. Enthusiasts want expert-level challenges with minimal guidance.
3. **Specify your budget for DIY rooms**: Budget constraints drive creative material choices. Knowing your limit upfront produces more practical designs.
4. **Request specific puzzle types**: If you know your group loves ciphers or hates math, say so. The designer will adjust the puzzle mix.
5. **Test with cold testers**: The single most important step after design. Recruit 2-3 people who have never seen the room and watch silently.
6. **Safety is non-negotiable**: Never truly lock anyone in. Always have an emergency exit. Always provide a safe word.
7. **Plan your reset**: If running for multiple groups, the reset procedure is as important as the design itself.
8. **Allow extra setup time**: First-time DIY designers consistently underestimate preparation time by 50%.

## Puzzle Category Reference

| Category | Types | Best For | Engagement |
|----------|-------|----------|------------|
| Logic | Deduction, sequence, math, spatial | Analytical thinkers | Individual focus |
| Search/Find | Hidden objects, secret compartments, UV ink | Explorers | Physical movement |
| Pattern Recognition | Color sequences, symbols, music, visual | Pattern-oriented minds | Observation |
| Physical Manipulation | Locks, mechanisms, dexterity, construction | Hands-on players | Tactile engagement |
| Codes/Ciphers | Caesar, pigpen, Morse, binary, book cipher | Code-breakers | Collaborative decoding |
| Observation | Hidden-in-plain-sight, perspective, detail | Detail-oriented players | Careful examination |
| Team Coordination | Simultaneous action, communication, roles | Group dynamics | Collaboration peaks |
| Technology | Sensors, electronics, digital, A/V | Tech-savvy groups | Professional rooms |

## Room Flow Reference

| Flow Model | Group Size | Complexity | Narrative Strength | Bottleneck Risk |
|------------|-----------|------------|-------------------|-----------------|
| Linear | 2-3 | Low | Strongest | Highest |
| Open/Parallel | 6+ | Medium | Weakest | Lowest |
| Multi-Linear | 4-6 | High | Strong | Moderate |
| Sequential + Bottlenecks | 4-8 | Medium-High | Strong | Moderate |

## Difficulty Reference

| Level | Puzzles | Escape Rate | Red Herrings | Hints |
|-------|---------|-------------|--------------|-------|
| Easy | 6-8 | 80-90% | None | Generous (automated) |
| Medium | 8-12 | 50-65% | 1-2 | Standard (on request) |
| Hard | 10-15 | 25-40% | 2-3 | Minimal (on request) |
| Expert | 12-18 | 10-25% | Multiple | Limited count |

---
Downloaded from [FindSkill.ai](https://findskill.ai)
