---
name: game-narrative-designer
version: 1.0.0
description: Game Narrative Designer for video games and TTRPGs. Provides frameworks for story arcs, branching dialogue trees, lore bibles, quest design, character arcs, environmental storytelling, and genre-specific narrative patterns.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a professional game narrative designer capable of creating comprehensive narrative systems for video games and tabletop RPGs. It provides structured frameworks for:

- Designing main quest lines and side quests with branching outcomes
- Building branching dialogue trees with skill checks and personality tracking
- Writing lore bibles covering world history, factions, religions, and magic systems
- Creating character arcs (redemption, corruption, tragedy, revenge, discovery, coming-of-age)
- Environmental storytelling through visual cues, found documents, and architectural narrative
- Genre-specific narrative patterns for RPG, horror, mystery, sci-fi, and open-world games
- Professional narrative design documentation and flowcharts
- Pacing, tension management, and player agency calibration

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
game-narrative-designer/
├── SKILL.md          # Main narrative design instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill - use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r game-narrative-designer/ ~/.claude/skills/game-narrative-designer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Describe your game project and narrative needs

## Usage Examples

### Designing a Main Quest Line

```
User: I'm making a dark fantasy RPG about a fallen kingdom. The theme is
"the cost of power." I need a main quest line with 3 branching endings.
The player starts as a common soldier who discovers they carry royal
blood. Target: mature gamers who love Baldur's Gate 3 and The Witcher 3.

AI: [Provides three-act quest structure with branching decision points,
faction involvement, thematic reinforcement, and three distinct endings
tied to the player's accumulated moral choices]
```

### Creating a Branching Dialogue Tree

```
User: I need a dialogue tree for a merchant NPC who secretly works for
the thieves guild. The player can buy from her, ask about rumors, or
confront her about suspicious behavior. Include skill checks.

AI: [Provides node-based dialogue tree with greeting, shopping branch,
rumor branch with information gating, confrontation branch with
Persuasion DC 15 and Intimidation DC 12 checks, flag system for
tracking what the player has discovered, and consequences for each path]
```

### Building a Lore Bible

```
User: I need a lore bible for a sci-fi setting where humanity discovered
an alien communication network 200 years ago. Three major factions
emerged from it. Help me build the world.

AI: [Provides structured lore bible with world overview, 200-year
timeline across eras, three faction profiles with philosophy/goals/
methods/leadership/secrets, the alien technology system with rules
and limitations, geography of key locations, naming conventions,
and a faction relationship matrix]
```

### Designing Environmental Storytelling

```
User: I'm designing an abandoned research facility for a horror game.
The scientists were studying something that broke containment. I need
environmental storytelling that reveals what happened layer by layer.

AI: [Provides multi-layered location narrative: Layer 1 (first glance)
shows obvious destruction, Layer 2 (investigation) reveals research
notes with escalating concern, Layer 3 (deep lore) connects to
broader world conspiracy, Layer 4 (secret) foreshadows the final boss.
Includes found document samples, visual storytelling beats, and
collectible placement plan]
```

### Writing a Side Quest

```
User: I need a moral dilemma side quest for an open-world fantasy game.
Theme: "Is truth always worth its cost?"

AI: [Provides complete quest design document with hook, three-obstacle
structure, complication twist, three meaningful choices each with
mechanical and narrative consequences, and connections to the game's
broader thematic framework]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{game_genre}}` | RPG | Genre of the game project |
| `{{narrative_scope}}` | main_quest | What to design (main_quest, side_quest, lore, dialogue) |
| `{{target_audience}}` | mature | Intended audience for the game |
| `{{theme}}` | power and its corruption | Central thematic concern |
| `{{player_agency_level}}` | branching | Degree of player choice (linear, branching, open, emergent) |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Start with theme**: Tell the AI what your game is *about* thematically before describing plot
2. **Specify genre**: Different genres have different narrative conventions and player expectations
3. **Define agency level**: Whether the player has linear, branching, open, or emergent control shapes everything
4. **Reference comparable titles**: Naming games you admire helps calibrate tone, complexity, and scope
5. **Ask iteratively**: Start with high-level structure, then drill into specific quests, dialogue, or lore sections
6. **Request documentation formats**: Ask for quest design documents, dialogue trees, or lore bibles in the structured template formats
7. **Test branching**: Ask the AI to walk through each branch of a dialogue tree or quest to verify coherence

## Supported Game Types

- RPGs (Western and JRPG styles)
- Action-Adventure
- Horror / Survival Horror
- Mystery / Detective
- Sci-Fi / Space Opera
- Open-World Sandbox
- Narrative Adventure / Walking Simulator
- Visual Novels / Interactive Fiction
- Tabletop RPGs (D&D, Pathfinder, indie systems)
- Roguelikes with narrative progression
- Live-service / Games-as-a-Service narrative

## Key References

This skill draws from established game narrative design principles including:
- Chris Bateman's *Game Writing: Narrative Skills for Videogames*
- GDC Vault narrative design talks
- Chris Avellone's RPG writing methodology
- Emily Short's interactive narrative research
- The GUMSHOE system's three-clue rule
- Syd Field's three-act structure adapted for interactivity

---
Downloaded from [FindSkill.ai](https://findskill.ai)
