---
name: interactive-fiction-writer
version: 1.0.0
description: Interactive Fiction Writer for creating choose-your-own-adventure stories with branching narratives, state tracking, meaningful choices, and multiple endings. Supports Twine, Ink, ChoiceScript, gamebooks, and plain text formats.
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a specialist interactive fiction writer capable of designing and writing complete branching narratives. It provides structured frameworks for:

- Designing story architectures (branching tree, hub-and-spoke, gauntlet, open map, time loop)
- Creating meaningful choice systems with real consequences (dilemma, expression, strategic, discovery choices)
- Managing branching narratives with convergence points and state-aware passages
- Building state tracking systems (flags, stats, inventory, relationships, quality-based narrative)
- Designing consequence chains (immediate, delayed, cascading, butterfly, cumulative)
- Writing second-person prose optimized for interactive fiction pacing
- Crafting multiple endings with calculation formulas (best, good, neutral, bad, hidden, true)
- Integrating puzzles (logic, inventory, dialogue, environmental) into narrative flow
- Genre-specific templates for horror, mystery, romance, fantasy, sci-fi, and thriller IF
- Platform-specific formatting for Twine, Ink, ChoiceScript, and plain text
- Testing and QA protocols for dead ends, loops, impossible states, and continuity errors

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
interactive-fiction-writer/
├── SKILL.md          # Main interactive fiction writing instructions and frameworks
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill - use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r interactive-fiction-writer/ ~/.claude/skills/interactive-fiction-writer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Describe your interactive fiction project and begin creating

## Usage Examples

### Designing a Complete Story Architecture

```
User: I want to create a horror interactive fiction set in an abandoned
hospital. The reader is a paranormal investigator. Stat-based choices
with Nerve, Perception, and Empathy. Medium length (40 passages).
Four distinct endings. Target platform is Twine.

AI: [Provides hub-and-spoke architecture with the hospital lobby as
central hub, wing-by-wing exploration spokes, sanity/nerve system,
inventory for found items and tools, four endings calculated from
accumulated stats and key choices, and Twine-formatted passage templates]
```

### Writing Individual Passages with Choices

```
User: Write the opening passage of my mystery IF. The reader arrives
at a remote island estate for a weekend party. One of the guests will
be murdered. I want to establish three potential suspects through
the first few choices.

AI: [Provides opening passage in second person present tense with
atmospheric description, three initial choices leading to different
NPC introductions, state flags for tracking who the reader has met,
and mood-appropriate pacing with sensory details]
```

### Designing a Choice Architecture

```
User: I have a key moment where the reader must choose between saving
their mentor or saving a village of strangers. How do I make this a
genuinely difficult choice instead of an obvious one?

AI: [Provides choice design analysis: how to balance emotional
attachment to mentor vs. utilitarian concern for villagers, how to
set up the dilemma through prior passages, what consequences each
choice triggers (immediate, delayed, and ending-impact), and how
to avoid making either choice "correct" through proportional and
fair consequence design]
```

### Building a State Tracking System

```
User: I'm writing a fantasy IF with 60 passages. I need a stat system,
inventory, and relationship tracking. What should my state system
look like?

AI: [Provides complete state design: 4 stats (Might, Cunning, Lore,
Charisma) with growth rules, flag registry documenting every flag
with where-set and where-checked, inventory system with 8 key items
and their narrative uses, relationship tracking for 3 major NPCs with
thresholds and consequences, and an ending calculation formula combining
all state elements]
```

### Creating Genre-Specific IF

```
User: Write a time-loop mystery IF outline. The reader relives the same
dinner party, and someone always dies at midnight. Each loop, they can
investigate different guests and areas. After enough loops, they can
prevent the murder.

AI: [Provides time-loop structure: core loop of 12 passages, tracked
loop_count variable, clues distributed across loops requiring 3+
loops to gather enough information, hub-and-spoke within each loop
(dinner party rooms as spokes), three possible culprits with the
three-clue rule applied to the real one, and endings for solving
it, failing, and a hidden ending for discovering the deeper truth]
```

### Platform-Specific Output

```
User: Convert this passage to Twine Harlowe format with conditional
text and inventory checks.

AI: [Provides passage formatted with Harlowe syntax: (if:) conditions,
(set:) variable assignments, [[link->passage]] navigation, conditional
text blocks based on flags and stats, and inline inventory checks]
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{genre}}` | fantasy | Genre of the interactive fiction story |
| `{{protagonist_type}}` | unnamed second-person | Who the reader plays as |
| `{{choice_complexity}}` | multi_path | Choice system complexity (simple_binary, multi_path, stat_based) |
| `{{story_length}}` | medium (30-50 passages) | Target story length |
| `{{tone}}` | atmospheric | Narrative tone and atmosphere |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot
- Llama 3 (70B+)
- Mistral Large

## Tips for Best Results

1. **Start with architecture**: Choose your story structure (branching tree, hub-and-spoke, gauntlet, open map, time loop) before writing any passages
2. **Design choices first**: Map out your choice architecture and consequence chains before writing prose
3. **Define your state system early**: Decide on stats, flags, and inventory before passage 1
4. **Use the passage format template**: Consistent structure makes complex branching manageable
5. **Apply the three-clue rule**: For any critical conclusion, provide at least 3 independent paths to discover it
6. **Test adversarially**: Play through making the worst possible choices to find dead ends and impossible states
7. **Specify your platform**: Mention Twine, Ink, ChoiceScript, or plain text for correctly formatted output
8. **Reference specific endings**: Tell the AI how many endings you want and what triggers each one
9. **Keep inventory small**: 5-8 items maximum to avoid cognitive overload for readers
10. **Show consequences visibly**: When a choice changes state, make it narratively visible to the reader

## Supported Interactive Fiction Types

- Choose-Your-Own-Adventure (classic gamebook format)
- Twine games (Harlowe and SugarCube story formats)
- Ink narratives (Inkle Studios scripting language)
- ChoiceScript novels (Choice of Games publishing format)
- Visual novel scripts (narrative with choices)
- Quality-based narrative (Fallen London / Failbetter Games style)
- Parser-adjacent IF (choice-based with parser flavor)
- Gamebook / Fighting Fantasy style (stat-based choices)
- Text adventure narratives
- Interactive fiction for mobile (Lifeline style)
- Educational branching scenarios
- Therapeutic/self-help interactive narratives

## Key References

This skill draws from established interactive fiction design principles including:
- Twine and the Twine community's documentation on choice-based IF craft
- Choice of Games design guidelines and ChoiceScript best practices
- Emily Short's extensive research on interactive narrative, choice design, and quality-based narrative
- The Interactive Fiction Database (IFDB) community standards and reviews
- Inkle Studios' Ink scripting language and narrative design philosophy (80 Days, Heaven's Vault)
- The GUMSHOE system's three-clue rule for mystery design
- Failbetter Games' quality-based narrative model (Fallen London, Sunless Sea)
- Classic gamebook design traditions (Choose Your Own Adventure, Fighting Fantasy, Lone Wolf)

---
Downloaded from [FindSkill.ai](https://findskill.ai)
